/*
 * Decompiled with CFR 0.152.
 */
package com.crimsoncrips.alexsmobsinteraction.mixins.mobs;

import com.crimsoncrips.alexsmobsinteraction.AMIReflectionUtil;
import com.crimsoncrips.alexsmobsinteraction.AlexsMobsInteraction;
import com.crimsoncrips.alexsmobsinteraction.misc.AMIUtils;
import com.github.alexthe666.alexsmobs.entity.EntityVoidWorm;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityVoidWorm.class})
public abstract class AMIVoidWorm
extends Monster {
    float damageTaken;
    int damageRetain;
    int stunTicks;
    private static final EntityDataAccessor<Boolean> STUNNED = SynchedEntityData.m_135353_(EntityVoidWorm.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynched(CallbackInfo ci) {
        this.f_19804_.m_135372_(STUNNED, (Object)false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditional(CompoundTag compound, CallbackInfo ci) {
        compound.m_128379_("Stunned", this.isStunned());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditional(CompoundTag compound, CallbackInfo ci) {
        this.setStunned(compound.m_128471_("Stunned"));
    }

    public boolean isStunned() {
        return (Boolean)this.f_19804_.m_135370_(STUNNED);
    }

    public void setStunned(boolean stunned) {
        this.f_19804_.m_135381_(STUNNED, (Object)stunned);
    }

    protected AMIVoidWorm(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean m_20068_() {
        return !this.isStunned();
    }

    protected boolean m_6107_() {
        return this.isStunned();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean prev = super.m_6469_(source, amount);
        if (!this.isStunned()) {
            this.damageTaken += amount;
        }
        this.damageRetain = 500;
        return prev;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (((Boolean)AlexsMobsInteraction.COMMON_CONFIG.VOIDWORM_STUN_ENABLED.get()).booleanValue()) {
            EntityVoidWorm voidWorm = (EntityVoidWorm)this;
            if (this.damageRetain > 0) {
                --this.damageRetain;
            }
            if (this.damageRetain < 0) {
                this.damageTaken = 0.0f;
            }
            if (this.m_20186_() > -50.0) {
                if (this.damageTaken > 30.0f) {
                    this.setStunned(true);
                    this.damageTaken = 0.0f;
                }
            } else {
                this.setStunned(false);
            }
            if (this.damageTaken > 30.0f) {
                if (this.m_20186_() > -50.0) {
                    AMIUtils.awardAdvancement((Entity)this.m_21188_(), "voidworm_stun", "stun");
                    this.setStunned(true);
                }
                this.damageTaken = 0.0f;
            }
            if (this.isStunned() && this.stunTicks > 0) {
                AMIReflectionUtil.setField(voidWorm, "stillTicks", 0);
                --this.stunTicks;
            } else {
                this.stunTicks = 100;
                this.setStunned(false);
            }
        }
    }
}

