/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.util;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantmentVisionHelper {
    public static boolean isBanned(Enchantment enchantment) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && visionData.has("banned")) {
            return VisionValueHandler.isBooleanMet(visionData, "banned");
        }
        return false;
    }

    public static int getMinLevel(Enchantment enchantment, int defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && visionData.has("min_level")) {
            return VisionValueHandler.isNumberMet(visionData, "min_level", defaultValue);
        }
        return defaultValue;
    }

    public static int getMaxLevel(Enchantment enchantment, int defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && visionData.has("max_level")) {
            return VisionValueHandler.isNumberMet(visionData, "max_level", defaultValue);
        }
        return defaultValue;
    }

    public static boolean isTreasure(Enchantment enchantment, @Nullable boolean defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (EnchantmentVisionHelper.isBanned(enchantment)) {
            return false;
        }
        if (visionData != null && visionData.has("treasure")) {
            return VisionValueHandler.isBooleanMet(visionData, "treasure");
        }
        return defaultValue;
    }

    public static boolean isTradeable(Enchantment enchantment, @Nullable boolean defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (EnchantmentVisionHelper.isBanned(enchantment)) {
            return false;
        }
        if (visionData != null && visionData.has("tradeable")) {
            return VisionValueHandler.isBooleanMet(visionData, "tradeable");
        }
        return defaultValue;
    }

    public static boolean isDiscoverable(Enchantment enchantment, @Nullable boolean defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (EnchantmentVisionHelper.isBanned(enchantment)) {
            return false;
        }
        if (visionData != null && visionData.has("discoverable")) {
            return VisionValueHandler.isBooleanMet(visionData, "discoverable");
        }
        return defaultValue;
    }

    public static boolean isCurse(Enchantment enchantment, @Nullable boolean defaultValue) {
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && visionData.has("curse")) {
            return VisionValueHandler.isBooleanMet(visionData, "curse");
        }
        return defaultValue;
    }

    public static boolean canEnchant(Enchantment enchantment, ItemStack itemstack, @Nullable boolean defaultValue) {
        boolean matches;
        boolean exclusive;
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (EnchantmentVisionHelper.isBanned(enchantment)) {
            return false;
        }
        if (visionData == null) {
            return defaultValue;
        }
        if (visionData.has("exclusive_enchantable") && (exclusive = VisionValueHandler.isBooleanMet(visionData, "exclusive_enchantable"))) {
            if (visionData.has("enchantable")) {
                boolean matches2 = VisionValueHandler.matchItemList(visionData, "enchantable", itemstack);
                if (!matches2) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (visionData.has("enchantable") && (matches = VisionValueHandler.matchItemList(visionData, "enchantable", itemstack))) {
            return true;
        }
        return defaultValue;
    }

    public static boolean isCompatible(Enchantment enchantment, Enchantment otherEnchantment, @Nullable boolean defaultValue) {
        if (EnchantmentVisionHelper.isBanned(enchantment) || EnchantmentVisionHelper.isBanned(otherEnchantment)) {
            return false;
        }
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && (visionData.has("compatible") || visionData.has("incompatible"))) {
            return VisionValueHandler.EnchantmentCompatibleWith(visionData, enchantment, otherEnchantment);
        }
        return defaultValue;
    }

    public static Enchantment.Rarity getRarity(Enchantment enchantment, @Nullable Enchantment.Rarity defaultValue) {
        String rarity;
        JsonObject visionData = VisionHandler.getVisionData(enchantment);
        if (visionData != null && visionData.has("rarity") && (rarity = VisionValueHandler.getFirstValidString(visionData, "rarity").toLowerCase()) != null && !rarity.isEmpty()) {
            switch (rarity) {
                case "uncommon": {
                    return Enchantment.Rarity.UNCOMMON;
                }
                case "rare": {
                    return Enchantment.Rarity.RARE;
                }
                case "very_rare": {
                    return Enchantment.Rarity.VERY_RARE;
                }
            }
            return Enchantment.Rarity.COMMON;
        }
        return defaultValue;
    }
}

