/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.visions.resources;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import javax.annotation.Nullable;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.visions.util.VisionType;

public class VisionResourceHandler {
    private static final int DEFAULT_PRIORITY = 500;

    public static JsonObject processJsonObject(String folderName, JsonElement jsonElement) {
        VisionType visionType = VisionType.getFromDirectory(folderName);
        String listType = visionType.getListType();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (!listType.isEmpty()) {
            jsonObject = VisionResourceHandler.transformArrayKeyJson(jsonObject, listType);
        }
        for (String key : jsonObject.keySet()) {
            JsonElement newElement = jsonObject.get(key);
            JsonElement wrappedElement = VisionResourceHandler.wrapPrimitive(key, newElement);
            if (jsonObject.has(key)) {
                JsonObject existingObject = jsonObject.getAsJsonObject(key);
                int existingPriority = VisionResourceHandler.getPriorityFromWrapped(existingObject);
                int newPriority = VisionResourceHandler.getPriorityFromWrapped(wrappedElement.getAsJsonObject());
                if (newPriority > existingPriority) {
                    jsonObject.remove(key);
                    jsonObject.add(key, wrappedElement);
                    continue;
                }
                if (newPriority != existingPriority) continue;
                VisionResourceHandler.mergeJsonObjects(existingObject, wrappedElement.getAsJsonObject(), 0);
                continue;
            }
            jsonObject.add(key, wrappedElement);
        }
        return jsonObject;
    }

    public static JsonObject transformArrayKeyJson(JsonObject inputJson, String listType) {
        if (inputJson.has(listType) && inputJson.get(listType).isJsonArray()) {
            JsonArray listArray = inputJson.getAsJsonArray(listType);
            StringBuilder combinedKey = new StringBuilder();
            for (int i = 0; i < listArray.size(); ++i) {
                combinedKey.append(listArray.get(i).getAsString());
                if (i >= listArray.size() - 1) continue;
                combinedKey.append(",");
            }
            JsonObject wrappedContent = new JsonObject();
            for (Map.Entry entry : inputJson.entrySet()) {
                if (((String)entry.getKey()).equals(listType)) continue;
                wrappedContent.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            JsonObject resultObject = new JsonObject();
            resultObject.add(combinedKey.toString(), (JsonElement)wrappedContent);
            return resultObject;
        }
        return inputJson;
    }

    private static int getPriorityFromWrapped(JsonObject wrappedObject) {
        if (wrappedObject.has("priority")) {
            JsonObject firstPriorityObject;
            JsonArray priorityArray;
            JsonElement priorityElement = wrappedObject.get("priority");
            if (priorityElement.isJsonObject()) {
                JsonObject priorityObject = priorityElement.getAsJsonObject();
                if (priorityObject.has("value")) {
                    return priorityObject.get("value").getAsInt();
                }
            } else if (priorityElement.isJsonArray() && !(priorityArray = priorityElement.getAsJsonArray()).isEmpty() && priorityArray.get(0).isJsonObject() && (firstPriorityObject = priorityArray.get(0).getAsJsonObject()).has("value")) {
                return firstPriorityObject.get("value").getAsInt();
            }
        }
        return 0;
    }

    public static JsonElement wrapPrimitive(String key, @Nullable JsonElement element) {
        if (element != null && element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject wrappedObject = new JsonObject();
            for (String innerKey : obj.keySet()) {
                JsonElement innerElement = obj.get(innerKey);
                if (innerElement.isJsonPrimitive()) {
                    JsonObject valueObject = new JsonObject();
                    valueObject.add("value", innerElement);
                    JsonArray valueArray = new JsonArray();
                    valueArray.add((JsonElement)valueObject);
                    wrappedObject.add(innerKey, (JsonElement)valueArray);
                    continue;
                }
                wrappedObject.add(innerKey, innerElement);
            }
            return wrappedObject;
        }
        return element;
    }

    public static void mergeJsonObjects(JsonObject existingJsonObject, JsonObject newJsonObject, int depth) {
        for (String key : newJsonObject.keySet()) {
            JsonElement newElement = newJsonObject.get(key);
            if (existingJsonObject.has(key)) {
                JsonElement existingElement = existingJsonObject.get(key);
                if (existingElement.isJsonObject() && newElement.isJsonObject()) {
                    int existingPriority = VisionResourceHandler.getPriority(existingElement.getAsJsonObject());
                    int newPriority = VisionResourceHandler.getPriority(newElement.getAsJsonObject());
                    if (newPriority > existingPriority) {
                        existingJsonObject.add(key, newElement);
                        continue;
                    }
                    if (newPriority != existingPriority) continue;
                    VisionResourceHandler.mergeJsonObjects(existingElement.getAsJsonObject(), newElement.getAsJsonObject(), depth + 1);
                    continue;
                }
                if (!existingElement.isJsonObject() && !newElement.isJsonObject()) {
                    existingJsonObject.add(key, newElement);
                    continue;
                }
                VMinusMod.LOGGER.warn("Type mismatch for key: {}. Overwriting with new value.", (Object)key);
                existingJsonObject.add(key, newElement);
                continue;
            }
            existingJsonObject.add(key, newElement);
        }
    }

    private static int getPriority(JsonObject jsonObject) {
        JsonElement innerElement;
        JsonElement valueElement;
        if (jsonObject.has("value") && (valueElement = jsonObject.get("value")).isJsonArray() && !valueElement.getAsJsonArray().isEmpty() && (innerElement = valueElement.getAsJsonArray().get(0)).isJsonObject() && innerElement.getAsJsonObject().has("priority")) {
            return innerElement.getAsJsonObject().get("priority").getAsInt();
        }
        return 500;
    }
}

