/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.registry.util;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.lixir.vminus.block.GlassSlabBlock;
import net.lixir.vminus.block.GlassStairsBlock;
import net.lixir.vminus.block.ModFlammableRotatedPillarBlock;
import net.lixir.vminus.block.ModHangingSignBlock;
import net.lixir.vminus.block.ModLeavesBlock;
import net.lixir.vminus.block.ModStandingSignBlock;
import net.lixir.vminus.block.ModWallHangingSignBlock;
import net.lixir.vminus.block.ModWallSignBlock;
import net.lixir.vminus.block.StainedGlassSlabBlock;
import net.lixir.vminus.block.StainedGlassStairsBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GlassBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockSet {
    public static final ArrayList<BlockSet> BLOCK_SETS = new ArrayList();
    public static final ArrayList<String> usingMods = new ArrayList();
    private final ArrayList<RegistryObject<Block>> blocks = new ArrayList();
    private final String baseName;
    public WoodType woodType = null;
    private Block alternateBaseBlock = null;
    private RegistryObject<Block> baseBlock = null;
    private RegistryObject<Block> stairsBlock = null;
    private RegistryObject<Block> slabBlock = null;
    private RegistryObject<Block> wallBlock = null;
    private RegistryObject<Block> crackedBlock = null;
    private RegistryObject<Block> fenceBlock = null;
    private RegistryObject<Block> fenceGateBlock = null;
    private RegistryObject<Block> doorBlock = null;
    private RegistryObject<Block> trapDoorBlock = null;
    private RegistryObject<Block> pressurePlateBlock = null;
    private RegistryObject<Block> buttonBlock = null;
    private RegistryObject<Block> standingSignBlock = null;
    private RegistryObject<Block> wallSignBlock = null;
    private RegistryObject<Block> hangingSignBlock = null;
    private RegistryObject<Block> wallHangingSignBlock = null;
    private RegistryObject<Block> logBlock = null;
    private RegistryObject<Block> strippedLogBlock = null;
    private RegistryObject<Block> woodBlock = null;
    private RegistryObject<Block> strippedWoodBlock = null;
    private RegistryObject<Block> leavesBlock = null;
    private String copyBlock = null;
    private DyeColor dyeColor = null;
    private String alternateBaseName = null;
    private ResourceLocation creativeTabItem = new ResourceLocation("minecraft:bricks");
    private ResourceLocation afterCreativeTabItem = null;
    private ResourceLocation signAfterCreativeTabItem = null;
    private ToolType toolType = ToolType.HAND;
    private ToolStrength toolStrength = ToolStrength.NONE;
    private RenderType renderType = RenderType.NORMAL;
    private float hardness = 1.5f;
    private float resistance = 6.0f;
    private int offset = 1;
    private SoundType soundType = SoundType.f_56742_;
    private boolean includeWall = false;
    private boolean includeSlab = false;
    private boolean includeStairs = false;
    private boolean includeBaseBlock = true;
    private boolean includeCracked = false;
    private boolean includeFence = false;
    private boolean includeFenceGate = false;
    private boolean includePressurePlate = false;
    private boolean includeButton = false;
    private boolean includeTrapdoor = false;
    private boolean includeDoor = false;
    private boolean includeLog = false;
    private boolean includeSign = false;
    private boolean includeHangingSign = false;
    private boolean includeChiseled = false;
    private boolean includeLeaves = false;
    private boolean leavesColored = false;
    private boolean isWoodSet = false;
    private ResourceLocation leavesAfterCreativeTabItem;
    private String modId;

    public BlockSet(String baseName) {
        this.baseName = baseName;
    }

    public static String correctBaseName(String baseName) {
        if (baseName.endsWith("s")) {
            if (baseName.length() > 1 && baseName.charAt(baseName.length() - 2) == 's') {
                return baseName;
            }
            return baseName.substring(0, baseName.length() - 1);
        }
        return baseName;
    }

    public static String getAlternateBaseName(String inputString) {
        if (inputString != null && !inputString.isEmpty()) {
            String fixedBaseName = inputString;
            if (fixedBaseName.contains(":")) {
                fixedBaseName = fixedBaseName.substring(fixedBaseName.indexOf(":") + 1);
            }
            return fixedBaseName;
        }
        return null;
    }

    public static String getAlternateNamespace(String inputString) {
        if (inputString != null && !inputString.isEmpty()) {
            String fixedBaseName = inputString;
            if (fixedBaseName.contains(":")) {
                fixedBaseName = fixedBaseName.substring(0, fixedBaseName.indexOf(":"));
            }
            return fixedBaseName;
        }
        return null;
    }

    public static String renderTypeToString(RenderType renderType) {
        String strRenderType = "solid";
        switch (renderType) {
            case GLASS: {
                strRenderType = "cutout_mipped";
                break;
            }
            case NORMAL: {
                strRenderType = "solid";
                break;
            }
            case STAINED_GLASS: {
                strRenderType = "translucent";
            }
        }
        return strRenderType;
    }

    public BlockSet strength(float hardness, float resistance) {
        this.hardness = hardness;
        this.resistance = resistance;
        return this;
    }

    public BlockSet sound(SoundType soundType) {
        this.soundType = soundType;
        return this;
    }

    public BlockSet withWalls() {
        this.includeWall = true;
        return this;
    }

    public BlockSet inTabItem(ResourceLocation resourceLocation) {
        this.creativeTabItem = resourceLocation;
        return this;
    }

    public BlockSet inTabItem(TabType tabType) {
        ResourceLocation resourceLocation = null;
        switch (tabType) {
            case COLORED: {
                resourceLocation = new ResourceLocation("minecraft", "cyan_wool");
                break;
            }
            case BUILDING: {
                resourceLocation = new ResourceLocation("minecraft", "bricks");
                break;
            }
            case NATURAL: {
                resourceLocation = new ResourceLocation("minecraft", "grass_block");
                break;
            }
            case FUNCTIONAL: {
                resourceLocation = new ResourceLocation("minecraft", "oak_sign");
            }
        }
        if (resourceLocation != null) {
            this.creativeTabItem = resourceLocation;
        }
        return this;
    }

    public BlockSet setCopyBlock(String copyBlock) {
        this.copyBlock = copyBlock;
        return this;
    }

    public BlockSet withSlabs() {
        this.includeSlab = true;
        return this;
    }

    public BlockSet withStairs() {
        this.includeStairs = true;
        return this;
    }

    public BlockSet withStairsSlabWall() {
        this.includeStairs = true;
        this.includeWall = true;
        this.includeSlab = true;
        return this;
    }

    public BlockSet withStairsSlabWallNoBase() {
        this.includeStairs = true;
        this.includeWall = true;
        this.includeSlab = true;
        this.includeBaseBlock = false;
        return this;
    }

    public BlockSet withStairsSlab() {
        this.includeStairs = true;
        this.includeSlab = true;
        return this;
    }

    public BlockSet withStairsSlabNoBase() {
        this.includeStairs = true;
        this.includeSlab = true;
        this.includeBaseBlock = false;
        return this;
    }

    public BlockSet withoutBase() {
        this.includeBaseBlock = false;
        return this;
    }

    public BlockSet withCracked() {
        this.includeCracked = true;
        return this;
    }

    public BlockSet withFence() {
        this.includeFence = true;
        return this;
    }

    public BlockSet withFenceGate() {
        this.includeFenceGate = true;
        return this;
    }

    public BlockSet withPressurePlate() {
        this.includePressurePlate = true;
        return this;
    }

    public BlockSet withButton() {
        this.includeButton = true;
        return this;
    }

    public BlockSet withDoor() {
        this.includeDoor = true;
        return this;
    }

    public BlockSet withTrapDoor() {
        this.includeTrapdoor = true;
        return this;
    }

    public BlockSet withSign() {
        this.includeSign = true;
        return this;
    }

    public BlockSet setWoodSet() {
        this.isWoodSet = true;
        return this;
    }

    public BlockSet withHangingSign() {
        this.includeHangingSign = true;
        return this;
    }

    public BlockSet leavesNotColored() {
        this.leavesColored = false;
        return this;
    }

    public BlockSet woodSet() {
        this.includeBaseBlock = true;
        this.includeStairs = true;
        this.includeSlab = true;
        this.includeFence = true;
        this.includeFenceGate = true;
        this.includeDoor = true;
        this.includeTrapdoor = true;
        this.includePressurePlate = true;
        this.includeButton = true;
        this.includeSign = true;
        this.includeHangingSign = true;
        this.isWoodSet = true;
        this.includeLog = true;
        this.copyBlock = "minecraft:oak_planks";
        this.toolType = ToolType.AXE;
        this.includeLeaves = true;
        this.leavesColored = true;
        this.alternateBaseName = "detour:" + this.baseName + "_planks";
        this.creativeTabItem = new ResourceLocation("minecraft", "bricks");
        return this;
    }

    public boolean isWoodSet() {
        return this.isWoodSet;
    }

    public boolean hasWall() {
        return this.includeWall;
    }

    public boolean hasFence() {
        return this.includeFence;
    }

    public boolean hasFenceGate() {
        return this.includeFenceGate;
    }

    public boolean hasPressurePlate() {
        return this.includePressurePlate;
    }

    public boolean hasButton() {
        return this.includeButton;
    }

    public boolean hasDoor() {
        return this.includeDoor;
    }

    public boolean hasTrapdoor() {
        return this.includeTrapdoor;
    }

    public boolean areLeavesColored() {
        return this.leavesColored;
    }

    public boolean hasSign() {
        return this.includeSign;
    }

    public boolean hasLog() {
        return this.includeLog;
    }

    public boolean hasLeaves() {
        return this.includeLeaves;
    }

    public boolean hasHangingSign() {
        return this.includeHangingSign;
    }

    public boolean hasChiseled() {
        return this.includeChiseled;
    }

    public boolean hasSlab() {
        return this.includeSlab;
    }

    public boolean hasStairs() {
        return this.includeStairs;
    }

    public boolean hasCracked() {
        return this.includeCracked;
    }

    public boolean hasBase() {
        return this.includeBaseBlock;
    }

    public ArrayList<RegistryObject<Block>> getBlocks() {
        return this.blocks;
    }

    public int getOffset() {
        return this.offset;
    }

    public BlockSet setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public BlockSet setDye(DyeColor dyeColor) {
        this.dyeColor = dyeColor;
        return this;
    }

    public Block getBaseBlock() {
        if (this.hasBase()) {
            return (Block)this.baseBlock.get();
        }
        if (this.alternateBaseName != null && !this.alternateBaseName.isEmpty()) {
            return this.alternateBaseBlock;
        }
        return null;
    }

    public Block getStairsBlock() {
        if (this.hasStairs()) {
            return (Block)this.stairsBlock.get();
        }
        return null;
    }

    public WoodType getWoodType() {
        return this.woodType;
    }

    public Block getSlabBlock() {
        if (this.hasSlab()) {
            return (Block)this.slabBlock.get();
        }
        return null;
    }

    public Block getFenceBlock() {
        if (this.hasFence()) {
            return (Block)this.fenceBlock.get();
        }
        return null;
    }

    public Block getFenceGateBlock() {
        if (this.hasFenceGate()) {
            return (Block)this.fenceGateBlock.get();
        }
        return null;
    }

    public Block getPressurePlateBlock() {
        if (this.hasPressurePlate()) {
            return (Block)this.pressurePlateBlock.get();
        }
        return null;
    }

    public Block getButtonBlock() {
        if (this.hasButton()) {
            return (Block)this.buttonBlock.get();
        }
        return null;
    }

    public Block getWallBlock() {
        if (this.hasWall()) {
            return (Block)this.wallBlock.get();
        }
        return null;
    }

    public Block getDoorBlock() {
        if (this.hasDoor()) {
            return (Block)this.doorBlock.get();
        }
        return null;
    }

    public Block getTrapdoorBlock() {
        if (this.hasTrapdoor()) {
            return (Block)this.trapDoorBlock.get();
        }
        return null;
    }

    public Block getCrackedBlock() {
        if (this.hasCracked()) {
            return (Block)this.crackedBlock.get();
        }
        return null;
    }

    public Block getStandingSignBlock() {
        if (this.hasSign()) {
            return (Block)this.standingSignBlock.get();
        }
        return null;
    }

    public Block getWallSignBlock() {
        if (this.hasSign()) {
            return (Block)this.wallSignBlock.get();
        }
        return null;
    }

    public Block getHangingSignBlock() {
        if (this.hasHangingSign()) {
            return (Block)this.hangingSignBlock.get();
        }
        return null;
    }

    public Block getWallHangingSignBlock() {
        if (this.hasHangingSign()) {
            return (Block)this.wallHangingSignBlock.get();
        }
        return null;
    }

    public Block getLogBlock() {
        if (this.hasLog()) {
            return (Block)this.logBlock.get();
        }
        return null;
    }

    public Block getLeavesBlock() {
        if (this.hasLeaves()) {
            return (Block)this.leavesBlock.get();
        }
        return null;
    }

    public Block getStrippedLogBlock() {
        if (this.hasLog()) {
            return (Block)this.strippedLogBlock.get();
        }
        return null;
    }

    public Block getWoodBlock() {
        if (this.hasLog()) {
            return (Block)this.woodBlock.get();
        }
        return null;
    }

    public Block getStrippedWoodBlock() {
        if (this.hasLog()) {
            return (Block)this.strippedWoodBlock.get();
        }
        return null;
    }

    public ResourceLocation getTabItem() {
        return this.creativeTabItem;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getAlternateBaseName() {
        if (this.alternateBaseName != null && !this.alternateBaseName.isEmpty()) {
            String fixedBaseName = this.alternateBaseName;
            if (fixedBaseName.contains(":")) {
                fixedBaseName = fixedBaseName.substring(fixedBaseName.indexOf(":"), fixedBaseName.length() - 1);
            }
            return fixedBaseName;
        }
        return null;
    }

    public BlockSet setAlternateBaseName(String alternateBaseName) {
        this.alternateBaseName = alternateBaseName;
        return this;
    }

    public String getAlternateBaseNameRaw() {
        return this.alternateBaseName;
    }

    public ResourceLocation getSignAfterCreativeTabItem() {
        return this.signAfterCreativeTabItem;
    }

    public ResourceLocation getAfterCreativeTabItem() {
        return this.afterCreativeTabItem;
    }

    public ToolType getTooltype() {
        return this.toolType;
    }

    public BlockSet withToolType(ToolType toolType) {
        this.toolType = toolType;
        return this;
    }

    public ToolStrength getToolStrength() {
        return this.toolStrength;
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public BlockSet setRenderType(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public BlockSet withToolStrength(ToolStrength toolStrength) {
        this.toolStrength = toolStrength;
        return this;
    }

    public BlockSet afterCreativeItem(ResourceLocation resourceLocation) {
        this.afterCreativeTabItem = resourceLocation;
        return this;
    }

    public BlockSet signAfterCreativeItem(ResourceLocation resourceLocation) {
        this.signAfterCreativeTabItem = resourceLocation;
        return this;
    }

    public BlockSet leavesAfterCreativeItem(ResourceLocation resourceLocation) {
        this.leavesAfterCreativeTabItem = resourceLocation;
        return this;
    }

    public String getAlternateNamespace() {
        if (this.alternateBaseName != null && !this.alternateBaseName.isEmpty()) {
            String fixedBaseName = this.alternateBaseName;
            if (fixedBaseName.contains(":")) {
                fixedBaseName = fixedBaseName.substring(0, fixedBaseName.indexOf(":"));
            }
            return fixedBaseName;
        }
        return null;
    }

    public Block getCorrectBlock(RegistryObject<Block> baseBlock, Block block) {
        if (baseBlock != null) {
            baseBlock.get();
            return (Block)baseBlock.get();
        }
        return block;
    }

    public String getModId() {
        return this.modId;
    }

    public Block getCopyBlock(RegistryObject<Block> baseBlock, Block block) {
        Block correctedBlock = null;
        if (this.copyBlock != null && !this.copyBlock.isEmpty()) {
            ResourceLocation resourceLocation = new ResourceLocation(this.copyBlock);
            correctedBlock = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        } else if (baseBlock != null) {
            correctedBlock = (Block)baseBlock.get();
        } else if (block != null) {
            correctedBlock = block;
        }
        return correctedBlock;
    }

    public Block getBlockWithRendering(BlockType blockType, BlockBehaviour.Properties properties) {
        return this.getBlockWithRendering(blockType, properties, null);
    }

    public Block getBlockWithRendering(BlockType blockType, BlockBehaviour.Properties properties, @Nullable Block block) {
        Object returnBlock = null;
        if (this.renderType == RenderType.GLASS) {
            switch (blockType) {
                case BASE: {
                    returnBlock = new GlassBlock(properties);
                    break;
                }
                case STAIRS: {
                    returnBlock = new GlassStairsBlock(() -> this.getCopyBlock(this.baseBlock, block).m_49966_(), properties);
                    break;
                }
                case SLAB: {
                    returnBlock = new GlassSlabBlock(properties);
                }
            }
        } else if (this.renderType == RenderType.STAINED_GLASS) {
            switch (blockType) {
                case BASE: {
                    returnBlock = new StainedGlassBlock(this.dyeColor, properties);
                    break;
                }
                case STAIRS: {
                    returnBlock = new StainedGlassStairsBlock(this.dyeColor, properties);
                    break;
                }
                case SLAB: {
                    returnBlock = new StainedGlassSlabBlock(this.dyeColor, properties);
                }
            }
        } else {
            switch (blockType) {
                case BASE: {
                    returnBlock = new Block(properties);
                    break;
                }
                case STAIRS: {
                    returnBlock = new StairBlock(() -> this.getCopyBlock(this.baseBlock, block).m_49966_(), properties);
                    break;
                }
                case SLAB: {
                    returnBlock = new SlabBlock(properties);
                    break;
                }
                case WALL: {
                    returnBlock = new WallBlock(properties);
                    break;
                }
                case FENCE: {
                    returnBlock = new FenceBlock(properties);
                    break;
                }
                case FENCE_GATE: {
                    returnBlock = new FenceGateBlock(properties, this.woodType);
                    break;
                }
                case PRESSURE_PLATE: {
                    returnBlock = new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, properties, BlockSetType.f_271198_);
                    break;
                }
                case BUTTON: {
                    returnBlock = new ButtonBlock(properties, BlockSetType.f_271198_, 15, true);
                    break;
                }
                case DOOR: {
                    returnBlock = new DoorBlock(properties, BlockSetType.f_271198_);
                    break;
                }
                case TRAPDOOR: {
                    returnBlock = new TrapDoorBlock(properties, BlockSetType.f_271198_);
                    break;
                }
                case LOG: {
                    returnBlock = new ModFlammableRotatedPillarBlock(properties);
                }
            }
        }
        return returnBlock;
    }

    public BlockSet build(String modId) {
        RegistryObject baseBlock;
        Block block;
        this.modId = modId;
        DeferredRegister itemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modId);
        DeferredRegister blockRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modId);
        if (this.isWoodSet) {
            this.woodType = WoodType.m_61844_((WoodType)new WoodType(modId + ":" + this.baseName, BlockSetType.f_271198_));
        }
        if (this.includeBaseBlock) {
            block = null;
            if (this.copyBlock != null && !this.copyBlock.isEmpty()) {
                Block copyBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(this.copyBlock));
                baseBlock = blockRegistry.register((String)(this.isWoodSet ? this.baseName + "_planks" : this.baseName), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyBlock)));
            } else {
                baseBlock = blockRegistry.register((String)(this.isWoodSet ? this.baseName + "_planks" : this.baseName), () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(this.hardness, this.resistance).m_60918_(this.soundType)));
            }
            itemRegistry.register((String)(this.isWoodSet ? this.baseName + "_planks" : this.baseName), () -> new BlockItem((Block)baseBlock.get(), new Item.Properties()));
            this.blocks.add((RegistryObject<Block>)baseBlock);
            this.baseBlock = baseBlock;
        } else {
            baseBlock = null;
            if (this.alternateBaseName != null && !this.alternateBaseName.isEmpty()) {
                ResourceLocation resourceLocation = new ResourceLocation(this.alternateBaseName.split(":")[0], this.alternateBaseName.split(":")[1]);
                this.alternateBaseBlock = block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
            } else {
                block = null;
            }
        }
        if (baseBlock != null || block != null) {
            String fixedBaseBlockId = BlockSet.correctBaseName(this.baseName);
            Block copyBlock = this.getCopyBlock((RegistryObject<Block>)baseBlock, block);
            if (this.includeCracked) {
                this.crackedBlock = blockRegistry.register("cracked_" + this.baseName, () -> this.getBlockWithRendering(BlockType.BASE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyBlock)));
                itemRegistry.register("cracked_" + this.baseName, () -> new BlockItem((Block)this.crackedBlock.get(), new Item.Properties()));
                this.blocks.add(this.crackedBlock);
            }
            if (this.includeStairs) {
                this.stairsBlock = blockRegistry.register(fixedBaseBlockId + "_stairs", () -> this.getBlockWithRendering(BlockType.STAIRS, BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyBlock), block));
                itemRegistry.register(fixedBaseBlockId + "_stairs", () -> new BlockItem((Block)this.stairsBlock.get(), new Item.Properties()));
                this.blocks.add(this.stairsBlock);
            }
            if (this.includeSlab) {
                this.slabBlock = blockRegistry.register(fixedBaseBlockId + "_slab", () -> this.getBlockWithRendering(BlockType.SLAB, BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyBlock)));
                itemRegistry.register(fixedBaseBlockId + "_slab", () -> new BlockItem((Block)this.slabBlock.get(), new Item.Properties()));
                this.blocks.add(this.slabBlock);
            }
            if (this.includeWall) {
                this.wallBlock = blockRegistry.register(fixedBaseBlockId + "_wall", () -> this.getBlockWithRendering(BlockType.WALL, BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyBlock)));
                itemRegistry.register(fixedBaseBlockId + "_wall", () -> new BlockItem((Block)this.wallBlock.get(), new Item.Properties()));
                this.blocks.add(this.wallBlock);
            }
            if (this.includeFence) {
                this.fenceBlock = blockRegistry.register(fixedBaseBlockId + "_fence", () -> this.getBlockWithRendering(BlockType.FENCE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50132_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_fence", () -> new BlockItem((Block)this.fenceBlock.get(), new Item.Properties()));
                this.blocks.add(this.fenceBlock);
            }
            if (this.includeFenceGate) {
                this.fenceGateBlock = blockRegistry.register(fixedBaseBlockId + "_fence_gate", () -> this.getBlockWithRendering(BlockType.FENCE_GATE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50192_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_fence_gate", () -> new BlockItem((Block)this.fenceGateBlock.get(), new Item.Properties()));
                this.blocks.add(this.fenceGateBlock);
            }
            if (this.includePressurePlate) {
                this.pressurePlateBlock = blockRegistry.register(fixedBaseBlockId + "_pressure_plate", () -> this.getBlockWithRendering(BlockType.PRESSURE_PLATE, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50167_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_pressure_plate", () -> new BlockItem((Block)this.pressurePlateBlock.get(), new Item.Properties()));
                this.blocks.add(this.pressurePlateBlock);
            }
            if (this.includeButton) {
                this.buttonBlock = blockRegistry.register(fixedBaseBlockId + "_button", () -> this.getBlockWithRendering(BlockType.BUTTON, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50251_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_button", () -> new BlockItem((Block)this.buttonBlock.get(), new Item.Properties()));
                this.blocks.add(this.buttonBlock);
            }
            if (this.includeDoor) {
                this.doorBlock = blockRegistry.register(fixedBaseBlockId + "_door", () -> this.getBlockWithRendering(BlockType.DOOR, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50154_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_door", () -> new BlockItem((Block)this.doorBlock.get(), new Item.Properties()));
                this.blocks.add(this.doorBlock);
            }
            if (this.includeTrapdoor) {
                this.trapDoorBlock = blockRegistry.register(fixedBaseBlockId + "_trapdoor", () -> this.getBlockWithRendering(BlockType.TRAPDOOR, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50216_ : copyBlock))));
                itemRegistry.register(fixedBaseBlockId + "_trapdoor", () -> new BlockItem((Block)this.trapDoorBlock.get(), new Item.Properties()));
                this.blocks.add(this.trapDoorBlock);
            }
            if (this.isWoodSet) {
                if (this.includeSign) {
                    this.standingSignBlock = blockRegistry.register(fixedBaseBlockId + "_sign", () -> new ModStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50095_ : copyBlock)), this.woodType));
                    this.wallSignBlock = blockRegistry.register(fixedBaseBlockId + "_wall_sign", () -> new ModWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50158_ : copyBlock)), this.woodType));
                    itemRegistry.register(fixedBaseBlockId + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)this.standingSignBlock.get(), (Block)this.wallSignBlock.get()));
                    this.blocks.add(this.standingSignBlock);
                    this.blocks.add(this.wallSignBlock);
                }
                if (this.includeHangingSign) {
                    this.hangingSignBlock = blockRegistry.register(fixedBaseBlockId + "_hanging_sign", () -> new ModHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_244319_ : copyBlock)), this.woodType));
                    this.wallHangingSignBlock = blockRegistry.register(fixedBaseBlockId + "_hanging_wall_sign", () -> new ModWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_244093_ : copyBlock)), this.woodType));
                    itemRegistry.register(fixedBaseBlockId + "_hanging_sign", () -> new SignItem(new Item.Properties().m_41487_(16), (Block)this.hangingSignBlock.get(), (Block)this.wallHangingSignBlock.get()));
                    this.blocks.add(this.hangingSignBlock);
                    this.blocks.add(this.wallHangingSignBlock);
                }
                if (this.includeLeaves) {
                    this.leavesBlock = blockRegistry.register(fixedBaseBlockId + "_leaves", () -> new ModLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)));
                    itemRegistry.register(fixedBaseBlockId + "_leaves", () -> new BlockItem((Block)this.leavesBlock.get(), new Item.Properties()));
                    this.blocks.add(this.leavesBlock);
                }
                if (this.includeLog) {
                    String logId = fixedBaseBlockId + "_log";
                    String strippedLogId = "stripped_" + logId;
                    String woodId = fixedBaseBlockId + "_wood";
                    String strippedWoodId = "stripped_" + woodId;
                    this.logBlock = blockRegistry.register(logId, () -> this.getBlockWithRendering(BlockType.LOG, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_49999_ : copyBlock))));
                    this.strippedLogBlock = blockRegistry.register(strippedLogId, () -> this.getBlockWithRendering(BlockType.LOG, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50010_ : copyBlock))));
                    this.woodBlock = blockRegistry.register(woodId, () -> this.getBlockWithRendering(BlockType.LOG, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50011_ : copyBlock))));
                    this.strippedWoodBlock = blockRegistry.register(strippedWoodId, () -> this.getBlockWithRendering(BlockType.LOG, BlockBehaviour.Properties.m_60926_((BlockBehaviour)(this.isWoodSet ? Blocks.f_50044_ : copyBlock))));
                    itemRegistry.register(logId, () -> new BlockItem((Block)this.logBlock.get(), new Item.Properties()));
                    itemRegistry.register(strippedLogId, () -> new BlockItem((Block)this.strippedLogBlock.get(), new Item.Properties()));
                    itemRegistry.register(woodId, () -> new BlockItem((Block)this.woodBlock.get(), new Item.Properties()));
                    itemRegistry.register(strippedWoodId, () -> new BlockItem((Block)this.strippedWoodBlock.get(), new Item.Properties()));
                    this.blocks.add(this.logBlock);
                    this.blocks.add(this.strippedLogBlock);
                    this.blocks.add(this.woodBlock);
                    this.blocks.add(this.strippedWoodBlock);
                }
            }
        }
        usingMods.add(this.modId);
        BLOCK_SETS.add(this);
        return this;
    }

    public static enum ToolType {
        PICKAXE,
        AXE,
        SHOVEL,
        HAND,
        HOE;

    }

    public static enum ToolStrength {
        NONE,
        WOODEN,
        STONE,
        IRON,
        DIAMOND,
        NETHERITE;

    }

    public static enum RenderType {
        NORMAL,
        GLASS,
        STAINED_GLASS;

    }

    public static enum TabType {
        BUILDING,
        NATURAL,
        COLORED,
        FUNCTIONAL;

    }

    public static enum BlockType {
        BASE,
        STAIRS,
        SLAB,
        WALL,
        FENCE,
        FENCE_GATE,
        PRESSURE_PLATE,
        DOOR,
        TRAPDOOR,
        SIGN,
        HANGING_SIGN,
        BUTTON,
        LOG;

    }
}

