/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.items;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import net.lixir.vminus.mixins.items.ItemAccessor;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionPropertyNameHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Unique
    private final Item vminus$item = (Item)this;

    @Inject(method={"getMaxStackSize"}, at={@At(value="HEAD")}, cancellable=true)
    public final void getMaxStackSize(CallbackInfoReturnable<Integer> cir) {
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        String propertyMet = VisionPropertyNameHandler.propertyMet(itemData, "stack_size");
        if (!propertyMet.isEmpty()) {
            int newStackSize = VisionValueHandler.isNumberMet(itemData, propertyMet, Integer.valueOf(cir.getReturnValue() != null ? (Integer)cir.getReturnValue() : 64), itemstack);
            cir.setReturnValue((Object)Math.max(newStackSize, 1));
        }
    }

    @Inject(method={"getFoodProperties"}, at={@At(value="RETURN")}, cancellable=true)
    private void getFoodProperties(CallbackInfoReturnable<FoodProperties> cir) {
        if (this.vminus$item == null || this.vminus$item.equals(Items.f_41852_)) {
            return;
        }
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        FoodProperties originalProperties = (FoodProperties)cir.getReturnValue();
        FoodProperties.Builder modifiedFoodProperties = null;
        if (originalProperties != null) {
            modifiedFoodProperties = new FoodProperties.Builder();
            modifiedFoodProperties.m_38760_(originalProperties.m_38744_());
            modifiedFoodProperties.m_38758_(originalProperties.m_38745_());
            List effects = originalProperties.m_38749_();
            for (Pair effectInstance : effects) {
                JsonObject visionData = VisionHandler.getVisionData(((MobEffectInstance)effectInstance.getFirst()).m_19544_());
                if (visionData != null && visionData.has("banned")) continue;
                modifiedFoodProperties.m_38762_((MobEffectInstance)effectInstance.getFirst(), ((Float)effectInstance.getSecond()).floatValue());
            }
            if (originalProperties.m_38747_()) {
                modifiedFoodProperties.m_38765_();
            }
            if (originalProperties.m_38746_()) {
                modifiedFoodProperties.m_38757_();
            }
            if (originalProperties.m_38748_()) {
                modifiedFoodProperties.m_38766_();
            }
        }
        if (itemData != null && itemData.has("food_properties")) {
            cir.setReturnValue((Object)VisionValueHandler.getFoodProperties(itemData, itemstack, modifiedFoodProperties != null ? modifiedFoodProperties.m_38767_() : originalProperties));
        } else if (modifiedFoodProperties != null) {
            cir.setReturnValue((Object)modifiedFoodProperties.m_38767_());
        }
    }

    @Inject(method={"isFireResistant"}, at={@At(value="HEAD")}, cancellable=true)
    public final void isFireResistant(CallbackInfoReturnable<Boolean> cir) {
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        if (itemData != null && itemData.has("fire_resistant")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(itemData, "fire_resistant", itemstack));
        }
    }

    @Inject(method={"isValidRepairItem"}, at={@At(value="HEAD")}, cancellable=true)
    public void isValidRepairItem(ItemStack p_41402_, ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        String repairItemId;
        JsonArray repairMaterialsJsonArray;
        List<String> repairMaterials;
        JsonObject itemData = VisionHandler.getVisionData(itemStack);
        if (itemData != null && itemData.has("repair_item") && (repairMaterials = VisionValueHandler.getStringListFromJsonArray(repairMaterialsJsonArray = itemData.getAsJsonArray("repair_item"))).contains(repairItemId = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getUseDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private void getUseDuration(CallbackInfoReturnable<Integer> cir) {
        int defaultDuration;
        int calculatedDuration;
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        if (itemData != null && itemData.has("use_duration") && (calculatedDuration = VisionValueHandler.isNumberMet(itemData, "use_duration", Integer.valueOf(defaultDuration = 32), itemstack).intValue()) != defaultDuration) {
            cir.setReturnValue((Object)calculatedDuration);
        }
    }

    @Inject(method={"isEdible"}, at={@At(value="HEAD")}, cancellable=true)
    private void isEdible(CallbackInfoReturnable<Boolean> cir) {
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        if (itemData != null && itemData.has("food_properties")) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getEnchantmentValue"}, at={@At(value="HEAD")}, cancellable=true)
    private void getEnchantmentValue(CallbackInfoReturnable<Integer> cir) {
        ItemStack itemstack = new ItemStack((ItemLike)this.vminus$item);
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        if (itemData != null && itemData.has("enchantability")) {
            cir.setReturnValue((Object)VisionValueHandler.isNumberMet(itemData, "enchantability", (Integer)cir.getReturnValue(), itemstack));
        }
    }

    @Inject(method={"getRarity"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRarity(ItemStack itemstack, CallbackInfoReturnable<Rarity> cir) {
        int rarityLevel;
        CompoundTag tag = itemstack.m_41783_();
        String rarityString = "common";
        ItemAccessor accessor = (ItemAccessor)this.vminus$item;
        Rarity currentRarity = accessor.getRarity();
        if (currentRarity == Rarity.UNCOMMON) {
            rarityString = "uncommon";
        } else if (currentRarity == Rarity.RARE) {
            rarityString = "rare";
        } else if (currentRarity == Rarity.EPIC) {
            rarityString = "epic";
        }
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        if (itemData != null && itemData.has("rarity")) {
            rarityString = VisionValueHandler.getRarity(itemData, itemstack, rarityString).toLowerCase();
        }
        switch (rarityString) {
            case "uncommon": {
                int n = 1;
                break;
            }
            case "rare": {
                int n = 2;
                break;
            }
            case "epic": {
                int n = 3;
                break;
            }
            default: {
                int n = rarityLevel = 0;
            }
        }
        if (tag != null && itemstack.m_41793_()) {
            rarityLevel = ModList.get().isLoaded("detour") ? ++rarityLevel : (rarityLevel += 2);
        }
        switch (rarityLevel) {
            case 1: {
                cir.setReturnValue((Object)Rarity.UNCOMMON);
                break;
            }
            case 2: {
                cir.setReturnValue((Object)Rarity.RARE);
                break;
            }
            case 3: {
                cir.setReturnValue((Object)Rarity.EPIC);
                break;
            }
            default: {
                cir.setReturnValue((Object)Rarity.COMMON);
            }
        }
        cir.cancel();
    }
}

