/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins.entities;

import com.google.gson.JsonObject;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.lixir.vminus.SoundHelper;
import net.lixir.vminus.mixins.entities.LivingEntityAccessor;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private final LivingEntity vminus$entity = (LivingEntity)this;

    @Inject(method={"breakItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void breakItem(ItemStack itemstack, CallbackInfo ci) {
        LivingEntityAccessor accessor = (LivingEntityAccessor)this.vminus$entity;
        String soundString = VisionValueHandler.getFirstValidString(null, "break_sound", itemstack);
        if (soundString != null && !soundString.isEmpty()) {
            if (!itemstack.m_41619_()) {
                if (!((LivingEntity)this).m_20067_()) {
                    ResourceLocation customSound = new ResourceLocation(soundString);
                    SoundEvent customSoundEvent = BuiltInRegistries.f_256894_.m_6612_(customSound).orElse(SoundEvents.f_12018_);
                    ((LivingEntity)this).m_9236_().m_7785_(((LivingEntity)this).m_20185_(), ((LivingEntity)this).m_20186_(), ((LivingEntity)this).m_20189_(), customSoundEvent, ((LivingEntity)this).m_5720_(), 0.8f, 0.8f + ((LivingEntity)this).m_9236_().f_46441_.m_188501_() * 0.4f, false);
                }
                if (!VisionValueHandler.isBooleanMet(null, "no_break_particles", itemstack)) {
                    accessor.spawnItemParticles(itemstack, 5);
                }
            }
            ci.cancel();
        }
    }

    @Inject(method={"getLootTable"}, at={@At(value="HEAD")}, cancellable=true)
    public void getLootTable(CallbackInfoReturnable<ResourceLocation> cir) {
        if (this.vminus$entity.getPersistentData() != null && this.vminus$entity.getPersistentData().m_128441_("variant")) {
            ResourceLocation customLoot;
            String variant = this.vminus$entity.getPersistentData().m_128461_("variant");
            String entityName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.vminus$entity.m_6095_()).m_135815_();
            if (!variant.equals("normal") && (customLoot = new ResourceLocation("vminus:entities/variant/" + entityName + "/" + variant)) != null) {
                cir.setReturnValue((Object)customLoot);
            }
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")}, cancellable=true)
    private void tickEffects(CallbackInfo ci) {
        LivingEntityAccessor accessor = (LivingEntityAccessor)this.vminus$entity;
        Iterator<MobEffect> iterator = accessor.getActiveEffects().keySet().iterator();
        try {
            while (iterator.hasNext()) {
                MobEffect mobeffect = iterator.next();
                MobEffectInstance mobeffectinstance = accessor.getActiveEffects().get(mobeffect);
                if (!mobeffectinstance.m_19552_(this.vminus$entity, () -> accessor.callOnEffectUpdated(mobeffectinstance, true, null))) {
                    if (this.vminus$entity.m_9236_().f_46443_) continue;
                    iterator.remove();
                    accessor.callOnEffectRemoved(mobeffectinstance);
                    continue;
                }
                if (mobeffectinstance.m_19557_() % 600 != 0) continue;
                accessor.callOnEffectUpdated(mobeffectinstance, false, null);
            }
        }
        catch (ConcurrentModificationException mobeffect) {
            // empty catch block
        }
        if (accessor.isEffectsDirty()) {
            if (!this.vminus$entity.m_9236_().f_46443_) {
                accessor.callUpdateInvisibilityStatus();
                accessor.callUpdateGlowingStatus();
            }
            accessor.setEffectsDirty(false);
        }
        int i = -1;
        boolean flag1 = false;
        for (MobEffectInstance effectInstance : accessor.getActiveEffects().values()) {
            JsonObject visionData;
            if (effectInstance.m_19544_().m_8093_() || (visionData = VisionHandler.getVisionData(effectInstance.m_19544_())) != null && visionData.has("particle")) continue;
            i = effectInstance.m_19544_().m_19484_();
            flag1 = effectInstance.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL;
            break;
        }
        if (i > 0) {
            Random random = new Random(System.nanoTime());
            boolean flag = random.nextBoolean();
            if (flag1) {
                flag &= random.nextInt(8) == 0;
            }
            if (flag && i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                this.vminus$entity.m_9236_().m_7106_((ParticleOptions)(flag1 ? ParticleTypes.f_123770_ : ParticleTypes.f_123811_), this.vminus$entity.m_20208_(0.5), this.vminus$entity.m_20187_(), this.vminus$entity.m_20262_(0.5), d0, d1, d2);
            }
        }
        ci.cancel();
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    private void isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("water_sensitive")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(visionData, "water_sensitive", (Entity)this.vminus$entity));
        }
    }

    @Inject(method={"canDisableShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void canDisableShield(CallbackInfoReturnable<Boolean> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("disable_shields")) {
            System.out.println("DISABLING SHIELDS!");
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(visionData, "disable_shields", (Entity)this.vminus$entity));
        }
    }

    @Inject(method={"canBreatheUnderwater"}, at={@At(value="HEAD")}, cancellable=true)
    private void canBreatheUnderwater(CallbackInfoReturnable<Boolean> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("underwater_breathing")) {
            cir.setReturnValue((Object)VisionValueHandler.isBooleanMet(visionData, "underwater_breathing", (Entity)this.vminus$entity));
        }
    }

    @Inject(method={"getSoundVolume"}, at={@At(value="HEAD")}, cancellable=true)
    private void getSoundVolume(CallbackInfoReturnable<Float> cir) {
        float defaultVolume;
        float totalVolume;
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("volume") && (totalVolume = VisionValueHandler.isNumberMet(visionData, "volume", Float.valueOf(defaultVolume = 1.0f), (Entity)this.vminus$entity).floatValue()) != defaultVolume) {
            cir.setReturnValue((Object)Float.valueOf(Math.max(totalVolume, 0.0f)));
        }
    }

    @Inject(method={"getExperienceReward"}, at={@At(value="HEAD")}, cancellable=true)
    private void getExperienceReward(CallbackInfoReturnable<Integer> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("experience")) {
            int experience = VisionValueHandler.isNumberMet(visionData, "experience", Integer.valueOf(0), (Entity)this.vminus$entity);
            System.out.println("DROPPING NEW XP: " + experience);
            cir.setReturnValue((Object)Math.max(experience, 0));
        }
    }

    @Nullable
    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("death_sound")) {
            System.out.println("Trying deathsound");
            String soundString = VisionValueHandler.getFirstValidString(visionData, "death_sound", (Entity)this.vminus$entity);
            SoundEvent sound = SoundHelper.getSoundEventFromString(soundString);
            if (sound != null) {
                cir.setReturnValue((Object)sound);
            }
        }
    }

    @Nullable
    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getHurtSound(DamageSource p_219440_, CallbackInfoReturnable<SoundEvent> cir) {
        String soundString;
        SoundEvent sound;
        JsonObject visionData = VisionHandler.getVisionData(this.vminus$entity.m_6095_());
        if (visionData != null && visionData.has("hurt_sound") && (sound = SoundHelper.getSoundEventFromString(soundString = VisionValueHandler.getFirstValidString(visionData, "hurt_sound", (Entity)this.vminus$entity))) != null) {
            cir.setReturnValue((Object)sound);
        }
    }
}

