/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins;

import com.google.gson.JsonObject;
import net.lixir.vminus.VMinusMod;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffect.class})
public abstract class MobEffectMixin {
    @Unique
    private final MobEffect effect = (MobEffect)this;

    @Inject(method={"getColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getColor(CallbackInfoReturnable<Integer> cir) {
        JsonObject visionData = VisionHandler.getVisionData(this.effect);
        if (visionData != null && visionData.has("color")) {
            String color = VisionValueHandler.getFirstValidString(visionData, "color");
            if (color.startsWith("#")) {
                int colorInt = Integer.parseInt(color.substring(1), 16);
                cir.setReturnValue((Object)colorInt);
            } else {
                VMinusMod.LOGGER.warn("Mob Effect color must begin with a \"#\": " + this.effect);
            }
        }
    }

    @Inject(method={"getCategory"}, at={@At(value="HEAD")}, cancellable=true)
    public void getCategory(CallbackInfoReturnable<MobEffectCategory> cir) {
        String category;
        MobEffectCategory customCategory;
        JsonObject visionData = VisionHandler.getVisionData(this.effect);
        if (visionData != null && visionData.has("category") && (customCategory = this.getCategoryFromString(category = VisionValueHandler.getFirstValidString(visionData, "category"))) != null) {
            cir.setReturnValue((Object)customCategory);
        }
    }

    @Unique
    private MobEffectCategory getCategoryFromString(String category) {
        switch (category.toLowerCase()) {
            case "harmful": {
                return MobEffectCategory.HARMFUL;
            }
            case "beneficial": {
                return MobEffectCategory.BENEFICIAL;
            }
            case "neutral": {
                return MobEffectCategory.NEUTRAL;
            }
        }
        VMinusMod.LOGGER.warn("Unknown Mob Effect Category: " + category);
        return null;
    }
}

