/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.mixins;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;

@Unique
@Mixin(value={ChatFormatting.class})
public abstract class ChatFormattingMixin {
    @Shadow
    @Final
    @Mutable
    private static ChatFormatting[] $VALUES;
    private static final ChatFormatting INDIGO;
    private static final ChatFormatting LIGHT_PINK;
    private static final ChatFormatting PINK;
    private static final ChatFormatting ORANGE;
    private static final ChatFormatting CORAL;
    private static final ChatFormatting SKY_BLUE;
    private static final ChatFormatting PINE;
    private static final ChatFormatting PLUM;
    private static final ChatFormatting TOOTHPASTE;
    private static final ChatFormatting NEON_YELLOW;
    private static final ChatFormatting BROWN;
    private static final ChatFormatting DARK_BROWN;
    private static final ChatFormatting NEON_RED;
    private static final ChatFormatting COBALT;

    @Invoker(value="<init>")
    public static ChatFormatting chatFormattingInit(String internalName, int internalId, String p_12667_, char p_12668_, int p_12669_, @Nullable Integer p_12630_) {
        throw new AssertionError();
    }

    private static ChatFormatting addFormatting(String internalName, char code, int color) {
        ArrayList<ChatFormatting> categories = new ArrayList<ChatFormatting>(Arrays.asList($VALUES));
        int id = categories.get(categories.size() - 1).ordinal() + 1;
        ChatFormatting category = ChatFormattingMixin.chatFormattingInit(internalName, id, internalName, code, id, color);
        categories.add(category);
        $VALUES = categories.toArray(new ChatFormatting[0]);
        return category;
    }

    private static int hexToInt(String hexColor) {
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        return Integer.parseInt(hexColor, 16);
    }

    static {
        INDIGO = ChatFormattingMixin.addFormatting("INDIGO", 'g', ChatFormattingMixin.hexToInt("8653fc"));
        LIGHT_PINK = ChatFormattingMixin.addFormatting("LIGHT_PINK", 't', ChatFormattingMixin.hexToInt("f99dca"));
        PINK = ChatFormattingMixin.addFormatting("PINK", 'q', ChatFormattingMixin.hexToInt("f771b2"));
        ORANGE = ChatFormattingMixin.addFormatting("ORANGE", 'i', ChatFormattingMixin.hexToInt("fc702a"));
        CORAL = ChatFormattingMixin.addFormatting("CORAL", 'p', ChatFormattingMixin.hexToInt("fc8c5f"));
        SKY_BLUE = ChatFormattingMixin.addFormatting("SKY_BLUE", 'v', ChatFormattingMixin.hexToInt("7badfc"));
        PINE = ChatFormattingMixin.addFormatting("PINE", 'n', ChatFormattingMixin.hexToInt("629646"));
        PLUM = ChatFormattingMixin.addFormatting("PLUM", 'z', ChatFormattingMixin.hexToInt("4d3b7f"));
        TOOTHPASTE = ChatFormattingMixin.addFormatting("TOOTHPASTE", 'h', ChatFormattingMixin.hexToInt("2afcd2"));
        NEON_YELLOW = ChatFormattingMixin.addFormatting("NEON_YELLOW", 'y', ChatFormattingMixin.hexToInt("fce305"));
        BROWN = ChatFormattingMixin.addFormatting("BROWN", 'j', ChatFormattingMixin.hexToInt("82522e"));
        DARK_BROWN = ChatFormattingMixin.addFormatting("DARK_BROWN", 'u', ChatFormattingMixin.hexToInt("3a2b1f"));
        NEON_RED = ChatFormattingMixin.addFormatting("NEON_RED", 'x', ChatFormattingMixin.hexToInt("fc0521"));
        COBALT = ChatFormattingMixin.addFormatting("COBALT", 'C', ChatFormattingMixin.hexToInt("0059ff"));
    }
}

