/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.helpers;

import java.util.Collection;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ProtectionHelper {
    public static float applyProtection(float damage, LivingEntity entity, DamageSource source, String protectionType, String protectionTag) {
        if (source.m_269533_(TagKey.m_203882_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation(protectionTag))) || protectionType.equals("vminus:protection")) {
            float protectionPercentage = ProtectionHelper.getTotalProtectionValue((Entity)entity, protectionType);
            float reducedDamage = Math.min(damage * 0.99f, Math.max(0.0f, damage - damage * protectionPercentage));
            return reducedDamage;
        }
        return damage;
    }

    public static float getTotalProtectionValue(Entity entity, String protectionType) {
        LivingEntity livingEntity;
        block4: {
            block3: {
                if (!(entity instanceof LivingEntity)) break block3;
                livingEntity = (LivingEntity)entity;
                if (protectionType != null) break block4;
            }
            return 0.0f;
        }
        float prot = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = livingEntity.m_6844_(slot);
            float itemProtection = ProtectionHelper.getProtectionValueFromItem(itemStack, slot, protectionType);
            float generalProtection = ProtectionHelper.getProtectionValueFromItem(itemStack, slot, "vminus:protection");
            prot += itemProtection + generalProtection;
        }
        float finalProtection = Math.max(Math.min(prot, 100.0f), 0.0f);
        return finalProtection;
    }

    private static float getProtectionValueFromItem(ItemStack itemStack, EquipmentSlot slot, String attributeName) {
        if (itemStack.m_41619_()) {
            return 0.0f;
        }
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeName));
        if (attribute == null) {
            return 0.0f;
        }
        Collection modifiers = itemStack.m_41638_(slot).get((Object)attribute);
        if (modifiers != null && !modifiers.isEmpty()) {
            float protectionAmount = (float)modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
            return protectionAmount;
        }
        return 0.0f;
    }
}

