/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.events;

import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.lixir.vminus.registry.VMinusAttributes;
import net.lixir.vminus.visions.VisionHandler;
import net.lixir.vminus.visions.util.VisionValueHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ItemAttributeEventHandler {
    private static final ConcurrentHashMap<String, UUID> UUID_CACHE = new ConcurrentHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void addAttributeModifier(ItemAttributeModifierEvent event) {
        ItemStack copyStack;
        CompoundTag copyTag;
        Item element3;
        ItemStack itemstack = event.getItemStack();
        String itemId = ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_()).toString();
        JsonObject itemData = VisionHandler.getVisionData(itemstack);
        CompoundTag tag = itemstack.m_41783_();
        EquipmentSlot eventSlot = event != null ? event.getSlotType() : null;
        Boolean miningFlag = false;
        if (itemData != null && (itemData.has("attributes") || itemData.has("tag") || itemData.has("remove_attributes"))) {
            if (itemData.has("remove_attributes")) {
                JsonArray removeAttributesArray = itemData.getAsJsonArray("remove_attributes");
                HashSet attributesToRemove = new HashSet();
                for (Object element2 : removeAttributesArray) {
                    JsonObject removeData = element2.getAsJsonObject();
                    if (!removeData.has("id")) continue;
                    attributesToRemove.add(removeData.get("id").getAsString());
                }
                if (event != null) {
                    Multimap originalModifiers = event.getOriginalModifiers();
                    for (Attribute attribute : originalModifiers.keySet()) {
                        for (AttributeModifier modifier : originalModifiers.get((Object)attribute)) {
                            String modifierId = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString();
                            if (!attributesToRemove.contains(modifierId)) continue;
                            event.removeModifier(attribute, modifier);
                        }
                    }
                }
            }
            if (itemData.has("attributes") && (tag == null || !tag.m_128441_("broken"))) {
                JsonArray attributesArray = itemData.getAsJsonArray("attributes");
                for (Item element3 : attributesArray) {
                    UUID attributeUUID;
                    Attribute attribute;
                    boolean replace;
                    JsonObject attributeData = element3.getAsJsonObject();
                    if (!attributeData.has("id") || !attributeData.has("value")) continue;
                    String attributeId = attributeData.get("id").getAsString();
                    String attributeName = "";
                    if (attributeData.has("name")) {
                        attributeName = attributeData.get("name").getAsString();
                    } else {
                        if (attributeId.indexOf(".") != -1) {
                            attributeName = attributeId.substring(attributeId.indexOf(".") + 1);
                        } else if (attributeId.indexOf(":") != -1) {
                            attributeName = attributeId.substring(attributeId.indexOf(":") + 1);
                        }
                        attributeName = attributeName.replaceAll("_", " ");
                    }
                    String operationString = attributeData.has("operation") ? attributeData.get("operation").getAsString().toLowerCase() : "addition";
                    double attributeValue = attributeData.get("value").getAsDouble();
                    boolean bl = replace = attributeData.has("replace") && attributeData.get("replace").getAsBoolean();
                    if (replace && event != null) {
                        Multimap originalModifiers = event.getOriginalModifiers();
                        for (Attribute attribute2 : originalModifiers.keySet()) {
                            for (AttributeModifier modifier : originalModifiers.get((Object)attribute2)) {
                                String modifierId = ForgeRegistries.ATTRIBUTES.getKey((Object)attribute2).toString();
                                if (!modifierId.equals(attributeId)) continue;
                                event.removeModifier(attribute2, modifier);
                            }
                        }
                    }
                    AttributeModifier.Operation operation = switch (operationString) {
                        case "multiply_base" -> AttributeModifier.Operation.MULTIPLY_BASE;
                        case "multiply_total" -> AttributeModifier.Operation.MULTIPLY_TOTAL;
                        default -> AttributeModifier.Operation.ADDITION;
                    };
                    if ((attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributeId))) == null) continue;
                    String compositeId = itemId + "|" + attributeId;
                    if (attributeData.has("uuid")) {
                        attributeUUID = UUID.fromString(attributeData.get("uuid").getAsString());
                    } else if (UUID_CACHE.get(compositeId) != null) {
                        attributeUUID = UUID_CACHE.get(compositeId);
                    } else {
                        UUID randomUUID = UUID.randomUUID();
                        UUID_CACHE.put(compositeId, randomUUID);
                        attributeUUID = randomUUID;
                    }
                    EquipmentSlot slot = EquipmentSlot.MAINHAND;
                    if (attributeData.has("slot")) {
                        slot = EquipmentSlot.valueOf((String)attributeData.get("slot").getAsString().toUpperCase());
                    } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "armors/helmets")))) {
                        slot = EquipmentSlot.HEAD;
                    } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "armors/chestplates")))) {
                        slot = EquipmentSlot.CHEST;
                    } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "armors/leggings")))) {
                        slot = EquipmentSlot.LEGS;
                    } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "armors/boots")))) {
                        slot = EquipmentSlot.FEET;
                    }
                    if (eventSlot != slot) continue;
                    AttributeModifier modifier = new AttributeModifier(attributeUUID, attributeName, attributeValue, operation);
                    if (event == null) continue;
                    if (attributeId.equals("vminus:mining_speed")) {
                        miningFlag = true;
                    }
                    event.addModifier(attribute, modifier);
                }
            }
        }
        if (itemData != null && itemData.has("nbt") && (copyTag = (copyStack = VisionValueHandler.setNBTs(itemData, itemstack.m_41777_())).m_41784_()) != null && !copyTag.m_128456_()) {
            if (tag == null) {
                tag = itemstack.m_41784_();
            }
            element3 = copyTag.m_128431_().iterator();
            while (element3.hasNext()) {
                String key = (String)element3.next();
                tag.m_128365_(key, copyTag.m_128423_(key));
            }
            itemstack.m_41751_(tag);
        }
        if (ModList.get().isLoaded("detour") && itemstack.m_41792_()) {
            if (tag == null) {
                tag = itemstack.m_41784_();
            }
            if (!tag.m_128441_("enchantment_limit")) {
                int limit = 2;
                if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("detour:one_enchantment_limit")))) {
                    limit = 1;
                } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("detour:three_enchantment_limit")))) {
                    limit = 3;
                } else if (itemstack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("detour:four_enchantment_limit")))) {
                    limit = 4;
                }
                tag.m_128347_("enchantment_limit", (double)limit);
            }
        }
        if (eventSlot == EquipmentSlot.MAINHAND) {
            int efficiencyLevel = EnchantmentHelper.m_44831_((ItemStack)itemstack).getOrDefault(Enchantments.f_44984_, 0);
            if (efficiencyLevel > 0) {
                double miningSpeedValue = efficiencyLevel * efficiencyLevel + 1;
                AttributeModifier miningSpeedModifier = new AttributeModifier(UUID.fromString("83e34d00-65ae-11ef-814d-325096b39f47"), "Effeciency Mining Speed", miningSpeedValue, AttributeModifier.Operation.ADDITION);
                if (event != null) {
                    event.addModifier((Attribute)VMinusAttributes.MININGSPEED.get(), miningSpeedModifier);
                }
            }
            if (!miningFlag.booleanValue() && (element3 = itemstack.m_41720_()) instanceof TieredItem) {
                TieredItem tieredItem = (TieredItem)element3;
                double tierMiningSpeed = tieredItem.m_43314_().m_6624_();
                AttributeModifier tierMiningSpeedModifier = new AttributeModifier(UUID.fromString("e14d7c20-65ae-11ef-814d-325096b39f47"), "Tier Mining Speed", tierMiningSpeed, AttributeModifier.Operation.ADDITION);
                if (event != null) {
                    event.addModifier((Attribute)VMinusAttributes.MININGSPEED.get(), tierMiningSpeedModifier);
                }
            }
        }
    }
}

