/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.datagen;

import java.util.function.Consumer;
import net.lixir.vminus.registry.util.BlockSet;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class VMinusRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public VMinusRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(@NotNull Consumer<FinishedRecipe> pWriter) {
        for (BlockSet blockSet : BlockSet.BLOCK_SETS) {
            Block crackedBlock;
            Block wallBlock;
            Block stairsBlock;
            Block slabBlock;
            Block baseBlock = blockSet.getBaseBlock();
            if (baseBlock != null && blockSet.hasSlab() && (slabBlock = blockSet.getSlabBlock()) != null) {
                this.slabRecipe(pWriter, (ItemLike)baseBlock, (ItemLike)slabBlock);
            }
            if (baseBlock != null && blockSet.hasStairs() && (stairsBlock = blockSet.getStairsBlock()) != null) {
                this.stairsRecipe(pWriter, (ItemLike)baseBlock, (ItemLike)stairsBlock);
            }
            if (baseBlock != null && blockSet.hasWall() && (wallBlock = blockSet.getWallBlock()) != null) {
                this.wallRecipe(pWriter, (ItemLike)baseBlock, (ItemLike)wallBlock);
            }
            if (baseBlock == null || !blockSet.hasCracked() || (crackedBlock = blockSet.getCrackedBlock()) == null) continue;
            this.crackedRecipe((ItemLike)baseBlock, (ItemLike)crackedBlock);
        }
    }

    private void slabRecipe(Consumer<FinishedRecipe> writer, ItemLike baseBlock, ItemLike slabBlock) {
        if (ModList.get().isLoaded("detour")) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)4).m_126130_("BB").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        } else {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)6).m_126130_("BBB").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        }
    }

    private void stairsRecipe(Consumer<FinishedRecipe> writer, ItemLike baseBlock, ItemLike stairsBlock) {
        if (ModList.get().isLoaded("detour")) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairsBlock, (int)3).m_126130_("B  ").m_126130_("BB ").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        } else {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairsBlock, (int)4).m_126130_("B  ").m_126130_("BB ").m_126130_("BBB").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        }
    }

    private void wallRecipe(Consumer<FinishedRecipe> writer, ItemLike baseBlock, ItemLike wallBlock) {
        if (ModList.get().isLoaded("detour")) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallBlock, (int)2).m_126130_("B").m_126130_("B").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        } else {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallBlock, (int)6).m_126130_("BBB").m_126130_("BBB").m_126127_(Character.valueOf('B'), baseBlock).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock)).m_176498_(writer);
        }
    }

    private void crackedRecipe(ItemLike baseBlock, ItemLike crackedBlock) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{baseBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)crackedBlock, (float)0.1f, (int)200).m_126132_(VMinusRecipeProvider.m_176602_((ItemLike)baseBlock), (CriterionTriggerInstance)VMinusRecipeProvider.m_125977_((ItemLike)baseBlock));
    }
}

