/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.lixir.vminus.capes.Cape;
import net.lixir.vminus.capes.CapeHelper;
import net.lixir.vminus.network.VminusModVariables;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CapeCommand {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cape").requires(s -> s.m_6761_(1))).then(Commands.m_82129_((String)"capeId", (ArgumentType)StringArgumentType.string()).suggests(CapeCommand::getCapeSuggestions).executes(arguments -> {
            Player player = (Player)((CommandSourceStack)arguments.getSource()).m_81373_();
            String capeId = StringArgumentType.getString((CommandContext)arguments, (String)"capeId");
            if (player != null) {
                if (CapeHelper.ownsCape((Entity)player, capeId).booleanValue() || capeId.equals("default")) {
                    player.getCapability(VminusModVariables.PLAYER_VARIABLES_CAPABILITY, null).ifPresent(capability -> {
                        capability.cape_id = capeId;
                        capability.syncPlayerVariables((Entity)player);
                    });
                    player.m_213846_((Component)Component.m_237113_((String)("Cape set to " + capeId)).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"You do not own this cape or it does not exist.").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
            }
            return 0;
        })));
    }

    public static CompletableFuture<Suggestions> getCapeSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        Player entity = null;
        if (((CommandSourceStack)context.getSource()).m_81373_() instanceof Player) {
            entity = (Player)((CommandSourceStack)context.getSource()).m_81373_();
        }
        if (entity != null) {
            List<Cape> availableCapes = CapeHelper.getAvailableCapes(entity);
            for (Cape cape : availableCapes) {
                builder.suggest(cape.getId());
            }
        }
        builder.suggest("default");
        return builder.buildFuture();
    }
}

