/*
 * Decompiled with CFR 0.152.
 */
package net.lixir.vminus.client.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.lixir.vminus.registry.VMinusAttributes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class HealthLostStatBoostOverlay {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void eventHandler(RenderGuiEvent.Pre event) {
        int w = event.getWindow().m_85445_();
        int h = event.getWindow().m_85446_();
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null) {
            Level world = entity.m_9236_();
            double currentHealth = entity.m_21223_();
            double maxHealth = entity.m_21233_();
            float healthPercentage = (float)currentHealth / (float)maxHealth;
            float modifierSum = 0.0f;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemStack = entity.m_6844_(slot);
                if (itemStack.m_41619_()) continue;
                modifierSum += HealthLostStatBoostOverlay.getAttributeValueFromItem(itemStack, slot, (Attribute)VMinusAttributes.HEALTHLOSTSTATBOOST.get());
            }
            if (modifierSum > 0.0f) {
                float transparency = 1.0f - healthPercentage;
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.enableBlend();
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                event.getGuiGraphics().m_280163_(new ResourceLocation("vminus:textures/screens/stat_boost_damage_taken_overlay.png"), 0, 0, 0.0f, 0.0f, w, h, w, h);
                RenderSystem.depthMask((boolean)true);
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static float getAttributeValueFromItem(ItemStack itemStack, EquipmentSlot slot, Attribute attribute) {
        Collection modifiers = itemStack.m_41638_(slot).get((Object)attribute);
        if (modifiers != null && !modifiers.isEmpty()) {
            return (float)modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
        }
        return 0.0f;
    }
}

