/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.api.CDTags;
import com.github.talrey.createdeco.blocks.CageLampBlock;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CageLamps {
    public static final ResourceLocation YELLOW_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_default");
    public static final ResourceLocation YELLOW_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_default_off");
    public static final ResourceLocation RED_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_redstone");
    public static final ResourceLocation RED_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_redstone_off");
    public static final ResourceLocation GREEN_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_green");
    public static final ResourceLocation GREEN_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_green_off");
    public static final ResourceLocation BLUE_ON = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_soul");
    public static final ResourceLocation BLUE_OFF = new ResourceLocation("createdeco", "block/palettes/cage_lamp/light_soul_off");

    private static ShapedRecipeBuilder cageLampRecipeBuilder(ItemLike item, Supplier<Item> light) {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)item).m_126130_("n").m_126130_("t").m_126130_("p").m_126127_(Character.valueOf('t'), (ItemLike)light.get());
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> recipe(String metal, Supplier<Item> light) {
        return CageLamps.recipe(metal, light, null);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> recipe(String metalName, Supplier<Item> light, @Nullable Supplier<Item> nonstandardMaterial) {
        String metal = metalName.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        return (ctx, prov) -> {
            if (nonstandardMaterial != null) {
                CageLamps.cageLampRecipeBuilder((ItemLike)ctx.get(), light).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)nonstandardMaterial.get()})).m_126127_(Character.valueOf('n'), (ItemLike)nonstandardMaterial.get()).m_206416_(Character.valueOf('p'), CDTags.of((String)metal, (String)"plates").tag).m_176498_((Consumer)prov);
            } else {
                CageLamps.cageLampRecipeBuilder((ItemLike)ctx.get(), light).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(CDTags.of((String)metal, (String)"plates").tag).m_45077_()})).m_206416_(Character.valueOf('n'), CDTags.of((String)metal, (String)"nuggets").tag).m_206416_(Character.valueOf('p'), CDTags.of((String)metal, (String)"plates").tag).m_176498_((Consumer)prov);
            }
        };
    }

    public static BlockBuilder<CageLampBlock, ?> build(CreateRegistrate reg, String name, DyeColor color, ResourceLocation cage, ResourceLocation lampOn, ResourceLocation lampOff) {
        return reg.block(color.m_41065_().toLowerCase(Locale.ROOT) + "_" + name.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_lamp", p -> new CageLampBlock((BlockBehaviour.Properties)p, new Vector3f(0.3f, 0.3f, 0.0f))).properties(props -> props.m_60955_().m_60978_(0.5f).m_60918_(SoundType.f_56762_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0)).blockstate((ctx, prov) -> BlockStateGenerator.cageLamp(cage, lampOn, lampOff, ctx, prov)).addLayer(() -> RenderType::m_110457_).lang(color.name().charAt(0) + color.name().substring(1).toLowerCase() + " " + name + " Cage Lamp").simpleItem();
    }
}

