/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.violetmoon.quark.content.world.gen.FallenLogGenerator;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class FallenLogsModule
extends ZetaModule {
    @Config
    public static DimensionConfig dimensions = new DimensionConfig(false, new String[]{"minecraft:overworld"});
    @Config(description="Percentage of fallen logs spawning as hollow. Requires Hollow Logs Module to be enabled")
    public static double hollowChance = 0.7;
    @Config
    public static int rarity = 5;
    @Config(description="Chance for logs to spawn on water")
    public static double onWaterChance = 0.1;
    @Config
    public static int sparseBiomeRarity = 12;
    @Config(description="Tags that define which biomes can have which wood types")
    public static List<String> biomeTags = Arrays.asList("quark:has_fallen_acacia=minecraft:acacia_log", "quark:has_fallen_birch=minecraft:birch_log", "quark:has_fallen_cherry=minecraft:cherry_log", "quark:has_fallen_dark_oak=minecraft:dark_oak_log", "quark:has_fallen_jungle=minecraft:jungle_log", "quark:has_fallen_mangrove=minecraft:mangrove_log", "quark:has_fallen_oak=minecraft:oak_log", "quark:has_fallen_spruce=minecraft:spruce_log");
    public static Map<TagKey<Biome>, Block> blocksPerTag = new HashMap<TagKey<Biome>, Block>();
    public static TagKey<Biome> reducedLogsTag;
    public static TagKey<Block> canSpawnOnTag;

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        reducedLogsTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("quark", "has_lower_fallen_tree_density"));
        canSpawnOnTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("quark", "fallen_log_can_spawn_on"));
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new FallenLogGenerator(dimensions), (GenerationStep.Decoration)GenerationStep.Decoration.TOP_LAYER_MODIFICATION, (int)1);
    }

    @LoadEvent
    public final void configChanged(ZConfigChanged event) {
        blocksPerTag.clear();
        for (String s : biomeTags) {
            String[] toks = s.split("=");
            String k = toks[0];
            String v = toks[1];
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(k));
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(v));
            if (block == null) {
                throw new IllegalArgumentException("Block " + v + " doesn't exist");
            }
            blocksPerTag.put((TagKey<Biome>)tag, block);
        }
    }
}

