/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tweaks.module;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.event.SimpleHarvestEvent;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.base.network.message.HarvestMessage;
import org.violetmoon.quark.content.tweaks.module.HoeHarvestingModule;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZConfigChanged;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.network.IZetaMessage;
import org.violetmoon.zeta.util.MiscUtil;

@ZetaLoadModule(category="tweaks")
public class SimpleHarvestModule
extends ZetaModule {
    @Config(description="Can players harvest crops with empty hand clicks?")
    public static boolean emptyHandHarvest = true;
    @Config(description="Does harvesting crops with a hoe cost durability?")
    public static boolean harvestingCostsDurability = false;
    @Config(description="Should Quark look for(nonvanilla) crops, and handle them?")
    public static boolean doHarvestingSearch = true;
    @Config(description="Should villagers use simple harvest instead of breaking crops?")
    public static boolean villagersUseSimpleHarvest = true;
    @Config(description="Which crops can be harvested?\nFormat is: \"harvestState[,afterHarvest]\", i.e. \"minecraft:wheat[age=7]\" or \"minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]\"")
    public static List<String> harvestableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:wheat[age=7]", "minecraft:carrots[age=7]", "minecraft:potatoes[age=7]", "minecraft:beetroots[age=3]", "minecraft:nether_wart[age=3]", "minecraft:cocoa[age=2,facing=north],minecraft:cocoa[age=0,facing=north]", "minecraft:cocoa[age=2,facing=south],minecraft:cocoa[age=0,facing=south]", "minecraft:cocoa[age=2,facing=east],minecraft:cocoa[age=0,facing=east]", "minecraft:cocoa[age=2,facing=west],minecraft:cocoa[age=0,facing=west]"});
    @Config(description="Which blocks should right click harvesting simulate a click on instead of breaking?\nThis is for blocks like sweet berry bushes, which have right click harvesting built in.")
    public static List<String> rightClickableBlocks = Lists.newArrayList((Object[])new String[]{"minecraft:sweet_berry_bush", "minecraft:cave_vines"});
    public static final Map<BlockState, BlockState> crops = Maps.newHashMap();
    private static final Set<Block> cropBlocks = Sets.newHashSet();
    public static final Set<Block> rightClickCrops = Sets.newHashSet();
    public static TagKey<Block> simpleHarvestBlacklistedTag;
    public static boolean staticEnabled;
    private boolean isHarvesting = false;

    @LoadEvent
    public void setup(ZCommonSetup event) {
        simpleHarvestBlacklistedTag = BlockTags.create((ResourceLocation)new ResourceLocation("quark", "simple_harvest_blacklisted"));
    }

    @LoadEvent
    public void configChanged(ZConfigChanged event) {
        crops.clear();
        cropBlocks.clear();
        rightClickCrops.clear();
        staticEnabled = this.enabled;
        if (doHarvestingSearch) {
            for (Block b : BuiltInRegistries.f_256975_) {
                if (this.isVanilla(b)) continue;
                if (b instanceof CropBlock) {
                    CropBlock c = (CropBlock)b;
                    crops.put(c.m_52289_(c.m_7419_()), c.m_49966_());
                    continue;
                }
                if (!(b instanceof BushBlock) && !(b instanceof GrowingPlantBlock) || !(b instanceof BonemealableBlock)) continue;
                rightClickCrops.add(b);
            }
        }
        for (String harvestKey : harvestableBlocks) {
            String[] split = this.tokenize(harvestKey);
            BlockState initial = MiscUtil.fromString((String)split[0]);
            BlockState result = split.length > 1 ? MiscUtil.fromString((String)split[1]) : initial.m_60734_().m_49966_();
            if (initial.m_60734_() == Blocks.f_50016_) continue;
            crops.put(initial, result);
        }
        for (String blockName : rightClickableBlocks) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockName));
            if (block == Blocks.f_50016_) continue;
            rightClickCrops.add(block);
        }
        crops.values().forEach(bl -> cropBlocks.add(bl.m_60734_()));
    }

    private String[] tokenize(String harvestKey) {
        boolean inBracket = false;
        for (int i = 0; i < harvestKey.length(); ++i) {
            char charAt = harvestKey.charAt(i);
            if (charAt == '[') {
                inBracket = true;
                continue;
            }
            if (charAt == ']') {
                inBracket = false;
                continue;
            }
            if (charAt != ',' || inBracket) continue;
            return new String[]{harvestKey.substring(0, i), harvestKey.substring(i + 1)};
        }
        return new String[]{harvestKey};
    }

    private boolean isVanilla(Block entry) {
        ResourceLocation loc = BuiltInRegistries.f_256975_.m_7981_((Object)entry);
        return loc.m_135827_().equals("minecraft");
    }

    private static boolean harvestAndReplant(Level level, BlockPos pos, BlockState inWorld, @Nullable LivingEntity entity, @Nullable InteractionHand hand) {
        BlockState newBlock = crops.get(inWorld);
        if (newBlock == null) {
            return false;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack copy = entity == null || hand == null ? new ItemStack((ItemLike)Items.f_42398_) : entity.m_21120_(hand).m_41777_();
            MutableBoolean hasTaken = new MutableBoolean(false);
            Item blockItem = inWorld.m_60734_().m_5456_();
            Block.m_49874_((BlockState)inWorld, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)level.m_7702_(pos), (Entity)entity, (ItemStack)copy).forEach(stack -> {
                if (stack.m_41720_() == blockItem && !hasTaken.getValue().booleanValue()) {
                    stack.m_41774_(1);
                    hasTaken.setValue(true);
                }
                if (!stack.m_41619_()) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
            });
            boolean dropXp = entity instanceof Player;
            inWorld.m_222967_(serverLevel, pos, copy, dropXp);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)newBlock));
            level.m_46597_(pos, newBlock);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)inWorld));
        }
        return true;
    }

    @PlayEvent
    public void onClick(ZRightClickBlock event) {
        if (this.isHarvesting) {
            return;
        }
        this.isHarvesting = true;
        if (SimpleHarvestModule.click(event.getPlayer(), event.getHand(), event.getPos(), event.getHitVec())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)event.getLevel().f_46443_));
        }
        this.isHarvesting = false;
    }

    public static boolean tryHarvestOrClickCrop(Level level, BlockPos pos, @Nullable LivingEntity entity, @Nullable InteractionHand hand, boolean canRightClick) {
        Player p;
        if (entity instanceof Player && !level.m_7966_(p = (Player)entity, pos)) {
            return false;
        }
        BlockState worldBlock = level.m_8055_(pos);
        SimpleHarvestEvent.ActionType action = SimpleHarvestModule.getActionForBlock(worldBlock, canRightClick);
        if (action != SimpleHarvestEvent.ActionType.NONE) {
            SimpleHarvestEvent event = new SimpleHarvestEvent(worldBlock, pos, level, hand, (Entity)entity, action);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return false;
            }
            BlockPos newPos = event.getTargetPos();
            if (newPos != pos) {
                worldBlock = level.m_8055_(newPos);
            }
            if ((action = event.getAction()) == SimpleHarvestEvent.ActionType.HARVEST) {
                Player p2;
                if (entity instanceof Player && !Quark.FLAN_INTEGRATION.canBreak(p2 = (Player)entity, pos)) {
                    return false;
                }
                return SimpleHarvestModule.harvestAndReplant(level, pos, worldBlock, entity, hand);
            }
            if (action == SimpleHarvestEvent.ActionType.CLICK && entity instanceof Player) {
                Player p3 = (Player)entity;
                if (!Quark.FLAN_INTEGRATION.canInteract(p3, pos)) {
                    return false;
                }
                BlockHitResult hitResult = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, true);
                if (hand == null) {
                    hand = InteractionHand.MAIN_HAND;
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    return player.f_8941_.m_7179_(player, player.m_9236_(), player.m_21120_(hand), hand, hitResult).m_19077_();
                }
                return Quark.proxy.clientUseItem(p3, level, hand, hitResult).m_19077_();
            }
        }
        return false;
    }

    private static SimpleHarvestEvent.ActionType getActionForBlock(BlockState state, boolean closeEnoughToRightClick) {
        if (state.m_204336_(simpleHarvestBlacklistedTag)) {
            return SimpleHarvestEvent.ActionType.NONE;
        }
        if (closeEnoughToRightClick && rightClickCrops.contains(state.m_60734_())) {
            return SimpleHarvestEvent.ActionType.CLICK;
        }
        if (crops.containsKey(state)) {
            return SimpleHarvestEvent.ActionType.HARVEST;
        }
        return SimpleHarvestEvent.ActionType.NONE;
    }

    public static boolean click(Player player, InteractionHand hand, BlockPos pos, BlockHitResult pick) {
        if (player == null || hand == null || player.m_5833_()) {
            return false;
        }
        if (pick.m_6662_() != HitResult.Type.BLOCK || !pick.m_82425_().equals((Object)pos)) {
            return false;
        }
        Level level = player.m_9236_();
        BlockState stateAt = level.m_8055_(pos);
        BlockState modifiedState = Quark.ZETA.blockExtensions.get(stateAt).getToolModifiedStateZeta(stateAt, new UseOnContext(player, hand, pick), "hoe_till", true);
        if (modifiedState != null) {
            return false;
        }
        ItemStack inHand = player.m_21120_(hand);
        boolean isHoe = HoeHarvestingModule.isHoe(inHand);
        if (!emptyHandHarvest && !isHoe) {
            return false;
        }
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        if (isHoe && SimpleHarvestModule.getActionForBlock(stateAt, true) == SimpleHarvestEvent.ActionType.NONE && SimpleHarvestModule.getActionForBlock(stateAbove, true) == SimpleHarvestEvent.ActionType.NONE) {
            return false;
        }
        int range = HoeHarvestingModule.getRange(inHand);
        boolean hasHarvested = false;
        for (int x = 1 - range; x < range; ++x) {
            for (int z = 1 - range; z < range; ++z) {
                BlockPos shiftPos = pos.m_7918_(x, 0, z);
                if (!SimpleHarvestModule.tryHarvestOrClickCrop(level, shiftPos, (LivingEntity)player, hand, range > 1)) {
                    if (!SimpleHarvestModule.tryHarvestOrClickCrop(level, shiftPos = shiftPos.m_7494_(), (LivingEntity)player, hand, range > 1)) continue;
                    hasHarvested = true;
                    continue;
                }
                hasHarvested = true;
            }
        }
        if (!hasHarvested) {
            return false;
        }
        if (level.f_46443_) {
            if (inHand.m_41619_()) {
                QuarkClient.ZETA_CLIENT.sendToServer((IZetaMessage)new HarvestMessage(pos, hand));
            }
        } else if (harvestingCostsDurability && isHoe) {
            inHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
        return true;
    }
}

