/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.content.client.module.ImprovedTooltipsModule;
import org.violetmoon.zeta.client.event.play.ZGatherTooltipComponents;

public class MapTooltips {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");

    public static void makeTooltip(ZGatherTooltipComponents event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && stack.m_41720_() instanceof MapItem) {
            List tooltip = event.getTooltipElements();
            if (!ImprovedTooltipsModule.mapRequireShift || Screen.m_96638_()) {
                tooltip.add(1, Either.right((Object)new MapComponent(stack)));
            } else if (ImprovedTooltipsModule.mapRequireShift && !Screen.m_96638_()) {
                tooltip.add(1, Either.left((Object)Component.m_237115_((String)"quark.misc.map_shift")));
            }
        }
    }

    public record MapComponent(ItemStack stack) implements ClientTooltipComponent,
    TooltipComponent
    {
        public void m_183452_(@NotNull Font font, int tooltipX, int tooltipY, @NotNull GuiGraphics guiGraphics) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack pose = guiGraphics.m_280168_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)this.stack, (Level)mc.f_91073_);
            Integer mapID = MapItem.m_151131_((ItemStack)this.stack);
            if (mapdata == null) {
                return;
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int pad = 7;
            int size = 135 + pad;
            float scale = 0.5f;
            pose.m_85836_();
            pose.m_252880_((float)(tooltipX + 3), (float)(tooltipY + 3), 500.0f);
            pose.m_85841_(scale, scale, 1.0f);
            RenderSystem.enableBlend();
            guiGraphics.m_280163_(RES_MAP_BACKGROUND, -pad, -pad, 0.0f, 0.0f, size, size, size, size);
            pose.m_252880_(0.0f, 0.0f, 1.0f);
            mc.f_91063_.m_109151_().m_168771_(pose, (MultiBufferSource)guiGraphics.m_280091_(), mapID.intValue(), mapdata, true, 240);
        }

        public int m_142103_() {
            Minecraft mc = Minecraft.m_91087_();
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)this.stack, (Level)mc.f_91073_);
            return mapdata != null ? 75 : 0;
        }

        public int m_142069_(@NotNull Font font) {
            return 72;
        }
    }
}

