/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.base.util.BlockPropertyUtil;
import org.violetmoon.zeta.block.ZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;

public class WoodPostBlock
extends ZetaBlock
implements SimpleWaterloggedBlock {
    private static final float START = 0.0f;
    private static final float END = 16.0f;
    private static final float LEFT_EDGE = 6.0f;
    private static final float RIGHT_EDGE = 10.0f;
    private static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape UP_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_SHAPE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[192];
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<PostSideType>[] SIDES = new EnumProperty[]{EnumProperty.m_61587_((String)"connect_down", PostSideType.class), EnumProperty.m_61587_((String)"connect_up", PostSideType.class), EnumProperty.m_61587_((String)"connect_north", PostSideType.class), EnumProperty.m_61587_((String)"connect_south", PostSideType.class), EnumProperty.m_61587_((String)"connect_west", PostSideType.class), EnumProperty.m_61587_((String)"connect_east", PostSideType.class)};

    public WoodPostBlock(@Nullable ZetaModule module, Block parent, String prefix, SoundType sound) {
        super(Quark.ZETA.registryUtil.inherit(parent, s -> prefix + s.replace("_fence", "_post")), module, BlockPropertyUtil.copyPropertySafe(parent).m_60918_(sound));
        BlockState state = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y);
        for (EnumProperty<PostSideType> prop : SIDES) {
            state = (BlockState)state.m_61124_(prop, (Comparable)((Object)PostSideType.NONE));
        }
        this.m_49959_(state);
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT);
        this.setCreativeTab(CreativeModeTabs.f_256788_, (ItemLike)parent, true);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            if (!((PostSideType)((Object)state.m_61143_(SIDES[dir.ordinal()]))).isSolid()) continue;
            index += 1 << dir.ordinal();
        }
        VoxelShape cached = SHAPE_CACHE[index += 64 * ((Direction.Axis)state.m_61143_(AXIS)).ordinal()];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = this.isConnected(state, dir);
                if (!connected) continue;
                currShape = Shapes.m_83110_((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            WoodPostBlock.SHAPE_CACHE[index] = currShape;
            cached = currShape;
        }
        return cached;
    }

    private boolean isConnected(BlockState state, Direction dir) {
        if (state.m_61143_(AXIS) == dir.m_122434_()) {
            return true;
        }
        return ((PostSideType)((Object)state.m_61143_(SIDES[dir.ordinal()]))).isSolid();
    }

    public boolean m_7420_(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis = context.m_43719_().m_122434_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_(AXIS, (Comparable)axis);
        for (Direction d : Direction.values()) {
            if (axis == d.m_122434_()) continue;
            state = (BlockState)state.m_61124_(SIDES[d.ordinal()], (Comparable)((Object)PostSideType.get((LevelAccessor)level, pos, d)));
        }
        return state;
    }

    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        state = (BlockState)state.m_61124_(SIDES[facing.ordinal()], (Comparable)((Object)PostSideType.get(level, pos, facing)));
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, AXIS});
        for (EnumProperty<PostSideType> prop : SIDES) {
            builder.m_61104_(new Property[]{prop});
        }
    }

    public static enum PostSideType implements StringRepresentable
    {
        NONE("none"),
        CHAIN("chain"),
        OTHER_POST("other_post");

        private final String name;

        private PostSideType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }

        public boolean isSolid() {
            return this != NONE;
        }

        private static PostSideType get(LevelAccessor world, BlockPos pos, Direction d) {
            BlockState sideState = world.m_8055_(pos.m_121945_(d));
            if (sideState.m_60734_() instanceof ChainBlock && sideState.m_61143_((Property)BlockStateProperties.f_61365_) == d.m_122434_() || d == Direction.DOWN && sideState.m_60734_() instanceof LanternBlock && (Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_) != false || d == Direction.DOWN && sideState.m_60734_() instanceof CeilingHangingSignBlock) {
                return CHAIN;
            }
            if (sideState.m_60734_() instanceof WoodPostBlock && sideState.m_61143_(AXIS) == d.m_122434_()) {
                return OTHER_POST;
            }
            return NONE;
        }
    }
}

