/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.building.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.building.block.HollowFrameBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.RenderLayerRegistry;
import org.violetmoon.zeta.util.MiscUtil;

public class HollowWoodBlock
extends HollowFrameBlock {
    protected static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    protected static final BooleanProperty UP = BlockStateProperties.f_61366_;
    protected static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    protected static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    protected static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    protected static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    private final boolean flammable;

    public HollowWoodBlock(Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        this(Quark.ZETA.registryUtil.inherit(sourceLog, "hollow_%s"), sourceLog, module, flammable);
    }

    public HollowWoodBlock(String name, Block sourceLog, @Nullable ZetaModule module, boolean flammable) {
        super(name, module, MiscUtil.copyPropertySafe((BlockBehaviour)sourceLog).m_60960_((s, g, p) -> false));
        this.flammable = flammable;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(true)));
        if (module == null) {
            return;
        }
        module.zeta().renderLayerRegistry.put((Block)this, RenderLayerRegistry.Layer.CUTOUT_MIPPED);
    }

    @Override
    public byte getShapeCode(BlockState state) {
        return HollowWoodBlock.shapeCode(state, DOWN, UP, NORTH, SOUTH, WEST, EAST);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.m_61124_((Property)MiscUtil.directionProperty((Direction)dir), (Comparable)((Boolean)state.m_61143_((Property)MiscUtil.directionProperty((Direction)direction.m_55954_(dir)))));
        }
        return newState;
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirror) {
        BlockState newState = state;
        for (Direction dir : Direction.values()) {
            newState = (BlockState)newState.m_61124_((Property)MiscUtil.directionProperty((Direction)dir), (Comparable)((Boolean)state.m_61143_((Property)MiscUtil.directionProperty((Direction)mirror.m_54848_(dir)))));
        }
        return newState;
    }

    @Nullable
    public BlockState getToolModifiedStateZeta(BlockState state, UseOnContext context, String toolActionType, boolean simulate) {
        if ("axe_strip".equals(toolActionType)) {
            Vec3 exactPos = context.m_43720_();
            BlockPos centerPos = context.m_8083_();
            Direction face = Direction.m_122366_((double)(exactPos.f_82479_ - ((double)centerPos.m_123341_() + 0.5)), (double)(exactPos.f_82480_ - ((double)centerPos.m_123342_() + 0.5)), (double)(exactPos.f_82481_ - ((double)centerPos.m_123343_() + 0.5)));
            return (BlockState)state.m_61122_((Property)MiscUtil.directionProperty((Direction)face));
        }
        return super.getToolModifiedStateZeta(state, context, toolActionType, simulate);
    }

    @Override
    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> def) {
        super.m_7926_(def);
        def.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.flammable;
    }
}

