/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.entity;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.quark.addons.oddities.item.BackpackItem;
import org.violetmoon.quark.addons.oddities.module.TotemOfHoldingModule;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tweaks.compat.TotemOfHoldingCuriosCompat;

public class TotemOfHoldingEntity
extends Entity {
    private static final String TAG_ITEMS = "storedItems";
    private static final String TAG_CURIOS = "curiosList";
    private static final String TAG_DYING = "dying";
    private static final String TAG_OWNER = "owner";
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.m_135353_(TotemOfHoldingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int DEATH_TIME = 40;
    private int deathTicks = 0;
    private String owner;
    private List<ItemStack> storedItems = new LinkedList<ItemStack>();
    private List<ItemStack> equipedCurios = new LinkedList<ItemStack>();

    public TotemOfHoldingEntity(EntityType<? extends TotemOfHoldingEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DYING, (Object)false);
    }

    public void addItem(ItemStack stack) {
        this.storedItems.add(stack);
    }

    public void addCurios(ItemStack stack) {
        this.equipedCurios.add(stack);
    }

    public void setOwner(Player player) {
        this.owner = player.m_20148_().toString();
    }

    private Player getOwnerEntity() {
        for (Player player : this.m_9236_().m_6907_()) {
            String uuid = player.m_20148_().toString();
            if (!uuid.equals(this.owner)) continue;
            return player;
        }
        return null;
    }

    public boolean m_7313_(@NotNull Entity e) {
        if (!this.m_9236_().f_46443_ && e instanceof Player) {
            Player owner;
            Player player = (Player)e;
            if (!TotemOfHoldingModule.allowAnyoneToCollect && !player.m_150110_().f_35937_ && e != (owner = this.getOwnerEntity())) {
                return false;
            }
            int drops = Math.min(this.storedItems.size(), 3 + this.m_9236_().f_46441_.m_188503_(4));
            for (int i = 0; i < drops; ++i) {
                ItemStack stack = this.storedItems.remove(0);
                Item item = stack.m_41720_();
                if (item instanceof ArmorItem) {
                    ArmorItem armor = (ArmorItem)item;
                    EquipmentSlot slot = armor.m_40402_();
                    ItemStack curr = player.m_6844_(slot);
                    if (curr.m_41619_()) {
                        player.m_8061_(slot, stack);
                        stack = null;
                    } else if (!(curr.m_41720_() instanceof BackpackItem || EnchantmentHelper.m_44920_((ItemStack)curr) || EnchantmentHelper.m_44920_((ItemStack)stack))) {
                        player.m_8061_(slot, stack);
                        stack = curr;
                    }
                } else if (stack.m_41720_() instanceof ShieldItem) {
                    ItemStack curr = player.m_6844_(EquipmentSlot.OFFHAND);
                    if (curr.m_41619_()) {
                        player.m_8061_(EquipmentSlot.OFFHAND, stack);
                        stack = null;
                    }
                } else if (Quark.ZETA.isModLoaded("curios")) {
                    stack = TotemOfHoldingCuriosCompat.equipCurios(player, this.equipedCurios, stack);
                }
                if (stack == null || player.m_36356_(stack)) continue;
                this.m_5552_(stack, 0.0f);
            }
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123798_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.1, 0.5, 0.1, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), drops, 0.4, 0.5, 0.4, 0.0);
            }
        }
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        Player owner;
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (TotemOfHoldingModule.darkSoulsMode && (owner = this.getOwnerEntity()) != null && !this.m_9236_().f_46443_) {
            String ownerTotem = TotemOfHoldingModule.getTotemUUID(owner);
            if (!this.m_20148_().toString().equals(ownerTotem)) {
                this.dropEverythingAndDie();
            }
        }
        if (this.storedItems.isEmpty() && !this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DYING, (Object)true);
        }
        if (this.isDying()) {
            if (this.deathTicks > 40) {
                this.m_146870_();
            } else {
                ++this.deathTicks;
            }
        } else if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() + (Math.random() - 0.5) * 0.2, this.m_20189_(), Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
    }

    private void dropEverythingAndDie() {
        if (!TotemOfHoldingModule.destroyLostItems) {
            for (ItemStack storedItem : this.storedItems) {
                this.m_5552_(storedItem, 0.0f);
            }
        }
        this.storedItems.clear();
        this.equipedCurios.clear();
        this.m_146870_();
    }

    public int getDeathTicks() {
        return this.deathTicks;
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(DYING);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        ItemStack stack;
        CompoundTag cmp;
        int i;
        ListTag list = compound.m_128437_(TAG_ITEMS, 10);
        ListTag curiosList = compound.m_128437_(TAG_CURIOS, 10);
        this.storedItems = new LinkedList<ItemStack>();
        this.equipedCurios = new LinkedList<ItemStack>();
        for (i = 0; i < list.size(); ++i) {
            cmp = list.m_128728_(i);
            stack = ItemStack.m_41712_((CompoundTag)cmp);
            this.storedItems.add(stack);
        }
        for (i = 0; i < curiosList.size(); ++i) {
            cmp = curiosList.m_128728_(i);
            stack = ItemStack.m_41712_((CompoundTag)cmp);
            this.equipedCurios.add(stack);
        }
        boolean dying = compound.m_128471_(TAG_DYING);
        this.f_19804_.m_135381_(DYING, (Object)dying);
        this.owner = compound.m_128461_(TAG_OWNER);
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        ListTag list = new ListTag();
        ListTag curiosList = new ListTag();
        for (ItemStack stack : this.storedItems) {
            list.add((Object)stack.serializeNBT());
        }
        for (ItemStack equipedCurio : this.equipedCurios) {
            curiosList.add((Object)equipedCurio.serializeNBT());
        }
        compound.m_128365_(TAG_ITEMS, (Tag)list);
        compound.m_128365_(TAG_CURIOS, (Tag)curiosList);
        compound.m_128379_(TAG_DYING, this.isDying());
        if (this.owner != null) {
            compound.m_128359_(TAG_OWNER, this.owner);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

