/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.addons.oddities.block;

import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.violetmoon.quark.addons.oddities.block.be.MatrixEnchantingTableBlockEntity;
import org.violetmoon.quark.addons.oddities.module.MatrixEnchantingModule;
import org.violetmoon.quark.api.IEnchantmentInfluencer;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.zeta.block.IZetaBlock;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.BooleanSuppliers;

public class MatrixEnchantingTableBlock
extends EnchantmentTableBlock
implements IZetaBlock {
    private final ZetaModule module;
    private BooleanSupplier enabledSupplier = BooleanSuppliers.TRUE;

    public MatrixEnchantingTableBlock(ZetaModule module) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50201_));
        this.module = module;
        module.zeta().registry.registerBlock((Block)this, "matrix_enchanter", true);
        if (!MatrixEnchantingModule.automaticallyConvert) {
            this.setCreativeTab(CreativeModeTabs.f_256791_, (ItemLike)Blocks.f_50201_, false);
        }
    }

    @NotNull
    public MutableComponent m_49954_() {
        return Blocks.f_50201_.m_49954_();
    }

    public MatrixEnchantingTableBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }

    @Nullable
    public ZetaModule getModule() {
        return this.module;
    }

    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new MatrixEnchantingTableBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return MatrixEnchantingTableBlock.m_152132_(type, MatrixEnchantingModule.blockEntityType, MatrixEnchantingTableBlockEntity::tick);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult raytrace) {
        if (!(worldIn.m_7702_(pos) instanceof MatrixEnchantingTableBlockEntity)) {
            worldIn.m_151523_(this.m_142194_(pos, state));
        }
        if (Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)((MatrixEnchantingTableBlockEntity)worldIn.m_7702_(pos)), (BlockPos)pos);
            }
        } else {
            worldIn.m_46597_(pos, Blocks.f_50201_.m_49966_());
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void m_214162_(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        boolean enabled = Quark.ZETA.modules.isEnabled(MatrixEnchantingModule.class);
        boolean showInfluences = enabled && MatrixEnchantingModule.allowInfluencing;
        boolean allowUnderwater = enabled && MatrixEnchantingModule.allowUnderwaterEnchanting;
        boolean allowShort = enabled && MatrixEnchantingModule.allowShortBlockEnchanting;
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (rand.m_188503_(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    IEnchantmentInfluencer influencer;
                    BlockPos blockpos = pos.m_7918_(i, k, j);
                    BlockState state = worldIn.m_8055_(blockpos);
                    BlockPos test = pos.m_7918_(i / 2, 0, j / 2);
                    if (!worldIn.m_46859_(test) && (!allowUnderwater || worldIn.m_8055_(test).m_60734_() != Blocks.f_49990_) && (!allowShort || !MatrixEnchantingTableBlockEntity.isShortBlock(worldIn, test))) continue block1;
                    if (showInfluences && (influencer = MatrixEnchantingTableBlockEntity.getInfluencerFromBlock(state, worldIn, blockpos)) != null) {
                        float[] comp = influencer.getEnchantmentInfluenceColor((BlockGetter)worldIn, blockpos, state);
                        ParticleOptions extra = influencer.getExtraParticleOptions((BlockGetter)worldIn, blockpos, state);
                        double chance = influencer.getExtraParticleChance((BlockGetter)worldIn, blockpos, state);
                        if (comp != null || extra != null) {
                            int steps = 20;
                            double dx = (double)(pos.m_123341_() - blockpos.m_123341_()) / (double)steps;
                            double dy = (double)(pos.m_123342_() - blockpos.m_123342_()) / (double)steps;
                            double dz = (double)(pos.m_123343_() - blockpos.m_123343_()) / (double)steps;
                            for (int p = 0; p < steps; ++p) {
                                boolean doExtra;
                                boolean doDust = comp != null && rand.m_188500_() < 0.5;
                                boolean bl = doExtra = extra != null && rand.m_188500_() < chance;
                                if (!doDust && !doExtra) continue;
                                double px = (double)blockpos.m_123341_() + 0.5 + dx * (double)p + rand.m_188500_() * 0.2 - 0.1;
                                double py = (double)blockpos.m_123342_() + 0.5 + dy * (double)p + Math.sin((double)p / (double)steps * Math.PI) * 0.5 + rand.m_188500_() * 0.2 - 0.1;
                                double pz = (double)blockpos.m_123343_() + 0.5 + dz * (double)p + rand.m_188500_() * 0.2 - 0.1;
                                if (doDust) {
                                    worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(comp[0], comp[1], comp[2]), 1.0f), px, py, pz, 0.0, 0.0, 0.0);
                                }
                                if (!doExtra) continue;
                                worldIn.m_7106_(extra, px, py, pz, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                    if (!(state.getEnchantPowerBonus((LevelReader)worldIn, blockpos) > 0.0f)) continue;
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.0, (double)pos.m_123343_() + 0.5, (double)((float)i + rand.m_188501_()) - 0.5, (double)((float)k - rand.m_188501_()) - 1.0, (double)((float)j + rand.m_188501_()) - 0.5);
                }
            }
        }
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull LivingEntity placer, @NotNull ItemStack stack) {
        BlockEntity tileentity;
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (stack.m_41788_() && (tileentity = worldIn.m_7702_(pos)) instanceof MatrixEnchantingTableBlockEntity) {
            MatrixEnchantingTableBlockEntity matrixEnchanter = (MatrixEnchantingTableBlockEntity)tileentity;
            matrixEnchanter.setCustomName(stack.m_41786_());
        }
    }

    public void m_6810_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof MatrixEnchantingTableBlockEntity) {
            MatrixEnchantingTableBlockEntity enchanter = (MatrixEnchantingTableBlockEntity)tileentity;
            enchanter.dropItem(0);
            enchanter.dropItem(1);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }
}

