/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RelayerBlock
extends DirectionalBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public RelayerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_52588_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWER, POWERED, f_52588_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction dir = context.m_7820_();
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)dir);
        int p = this.getSignalInFront(context.m_43725_(), context.m_8083_(), dir);
        state = (BlockState)((BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(p))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(p != 0));
        return state;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.f_46443_) {
            this.updatePowerNextTick(state, worldIn, pos);
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        this.updatePowerNextTick(state, level, pos);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!level.m_5776_() && isMoving) {
            this.updatePowerNextTick(state, level, pos);
        }
    }

    private void updatePowerNextTick(BlockState state, Level level, BlockPos pos) {
        if (!level.m_183326_().m_183582_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    private int getSignalInFront(Level level, BlockPos pos, Direction dir) {
        BlockPos behind = pos.m_121945_(dir);
        int pow = level.m_277185_(behind, dir);
        BlockState b = level.m_8055_(behind);
        if (b.m_60734_() instanceof RedStoneWireBlock) {
            pow = Math.max((Integer)b.m_61143_((Property)RedStoneWireBlock.f_55500_), pow);
        } else {
            Block block = b.m_60734_();
            if (block instanceof DiodeBlock) {
                DiodeBlock repeaterBlock = (DiodeBlock)block;
                pow = Math.max(repeaterBlock.m_6378_(b, (BlockGetter)level, behind, (Direction)b.m_61143_((Property)DiodeBlock.f_54117_)), pow);
            } else if (b.m_60713_((Block)this)) {
                pow = Math.max((Integer)b.m_61143_((Property)POWER), pow);
            }
        }
        return pow;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        Direction front = (Direction)state.m_61143_((Property)f_52588_);
        Direction back = front.m_122424_();
        int pow = this.getSignalInFront((Level)level, pos, front);
        level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pow != 0))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(Mth.m_14045_((int)pow, (int)0, (int)15))), 7);
        BlockPos blockPos = pos.m_121945_(back);
        level.m_46586_(blockPos, (Block)this, pos);
        level.m_46590_(blockPos, (Block)this, front);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return state.m_60746_(level, pos, direction);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && state.m_61143_((Property)f_52588_) == direction) {
            return (Integer)state.m_61143_((Property)POWER);
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        if (direction == null) {
            return false;
        }
        return direction == state.m_61143_((Property)ObserverBlock.f_52588_);
    }
}

