/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.SackItem;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends WaterBlock
implements EntityBlock,
WorldlyContainerHolder {
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375)});
    protected static final VoxelShape SHAPE_UP = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)1.0, (double)0.815), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375));
    protected static final VoxelShape SHAPE_DOWN = Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375));
    protected static final VoxelShape SHAPE_UP_DOWN = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)1.0, (double)0.815);
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final EnumProperty<ModBlockProperties.DisplayStatus> ITEM_STATUS = ModBlockProperties.ITEM_STATUS;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(ITEM_STATUS, (Comparable)((Object)ModBlockProperties.DisplayStatus.EMPTY)));
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        PedestalBlockTile te;
        BlockEntity blockEntity;
        double power = CommonConfigs.Building.CRYSTAL_ENCHANTING.get();
        if (power != 0.0 && (blockEntity = world.m_7702_(pos)) instanceof PedestalBlockTile && (te = (PedestalBlockTile)blockEntity).getDisplayType() == PedestalBlockTile.DisplayType.CRYSTAL) {
            return (float)power;
        }
        return 0.0f;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, WATERLOGGED, ITEM_STATUS, AXIS});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        boolean flag = level.m_6425_(pos = context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_(AXIS, (Comparable)context.m_8125_().m_122434_())).m_61124_(ITEM_STATUS, (Comparable)((Object)PedestalBlock.getStatus((LevelAccessor)level, pos, false)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(level.m_8055_(pos.m_7494_()), pos, (LevelAccessor)level, Direction.UP, false)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(level.m_8055_(pos.m_7495_()), pos, (LevelAccessor)level, Direction.DOWN, false)));
    }

    public static boolean canConnectTo(BlockState state, BlockPos pos, LevelAccessor world, Direction dir, boolean hasItem) {
        if (state.m_60734_() instanceof PedestalBlock) {
            if (dir == Direction.DOWN) {
                return !((ModBlockProperties.DisplayStatus)((Object)state.m_61143_(ITEM_STATUS))).hasTile();
            }
            if (dir == Direction.UP) {
                return !hasItem;
            }
        }
        return false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
        if (facing == Direction.UP) {
            boolean hasItem = ((ModBlockProperties.DisplayStatus)((Object)stateIn.m_61143_(ITEM_STATUS))).hasItem();
            return (BlockState)((BlockState)stateIn.m_61124_(ITEM_STATUS, (Comparable)((Object)PedestalBlock.getStatus(level, currentPos, hasItem)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(facingState, currentPos, level, facing, hasItem)));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnectTo(facingState, currentPos, level, facing, ((ModBlockProperties.DisplayStatus)((Object)stateIn.m_61143_(ITEM_STATUS))).hasItem())));
        }
        return stateIn;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemDisplayTile tile;
        ItemStack i;
        BlockEntity blockEntity;
        if (target.m_82450_().m_7098_() > (double)(pos.m_123342_() + 1) - 0.1875 && (blockEntity = world.m_7702_(pos)) instanceof ItemDisplayTile && !(i = (tile = (ItemDisplayTile)blockEntity).getDisplayedItem()).m_41619_()) {
            return i;
        }
        return super.m_7397_(world, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        PedestalBlockTile tile;
        BlockEntity blockEntity;
        InteractionResult resultType = InteractionResult.PASS;
        if (((ModBlockProperties.DisplayStatus)((Object)state.m_61143_(ITEM_STATUS))).hasTile() && (blockEntity = level.m_7702_(pos)) instanceof PedestalBlockTile && (tile = (PedestalBlockTile)blockEntity).isAccessibleBy(player)) {
            ItemStack handItem = player.m_21120_(handIn);
            if (handItem.m_41720_() instanceof SackItem) {
                ItemStack it = handItem.m_41777_();
                it.m_41764_(1);
                ItemStack removed = tile.m_8016_(0);
                tile.setDisplayedItem(it);
                if (!player.m_7500_()) {
                    handItem.m_41774_(1);
                }
                if (!level.m_5776_()) {
                    player.m_21008_(handIn, removed);
                    level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.95f);
                    tile.m_6596_();
                } else {
                    tile.updateClientVisualsOnLoad();
                }
                resultType = InteractionResult.m_19078_((boolean)level.f_46443_);
            } else {
                resultType = tile.interact(player, handIn);
            }
        }
        return resultType;
    }

    public static boolean canHaveItemAbove(LevelAccessor level, BlockPos pos) {
        BlockState above = level.m_8055_(pos.m_7494_());
        return !above.m_60713_(ModRegistry.PEDESTAL.get()) && !above.m_60796_((BlockGetter)level, pos.m_7494_());
    }

    public static ModBlockProperties.DisplayStatus getStatus(LevelAccessor level, BlockPos pos, boolean hasItem) {
        if (hasItem) {
            return ModBlockProperties.DisplayStatus.FULL;
        }
        return PedestalBlock.canHaveItemAbove(level, pos) ? ModBlockProperties.DisplayStatus.EMPTY : ModBlockProperties.DisplayStatus.NONE;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean up = (Boolean)state.m_61143_((Property)UP);
        boolean down = (Boolean)state.m_61143_((Property)DOWN);
        if (!up) {
            if (!down) {
                return SHAPE;
            }
            return SHAPE_DOWN;
        }
        if (!down) {
            return SHAPE_UP;
        }
        return SHAPE_UP_DOWN;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (((ModBlockProperties.DisplayStatus)((Object)pState.m_61143_(ITEM_STATUS))).hasTile()) {
            return new PedestalBlockTile(pPos, pState);
        }
        return null;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof ItemDisplayTile) {
                ItemDisplayTile tile = (ItemDisplayTile)blockEntity;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)tile);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PedestalBlockTile) {
            PedestalBlockTile tile = (PedestalBlockTile)blockEntity;
            return tile.m_7983_() ? 0 : 15;
        }
        return 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.CLOCKWISE_180) {
            return state;
        }
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
            case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            default -> state;
        };
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockUtil.addOptionalOwnership(placer, world, pos);
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor level, BlockPos pos) {
        if (((ModBlockProperties.DisplayStatus)((Object)state.m_61143_(ITEM_STATUS))).hasTile()) {
            return (PedestalBlockTile)level.m_7702_(pos);
        }
        return new TileLessContainer(state, level, pos);
    }

    @Deprecated(forRemoval=true)
    static class TileLessContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private PedestalBlockTile tileReference = null;

        public TileLessContainer(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos) {
            super(1);
            this.state = blockState;
            this.level = levelAccessor;
            this.pos = blockPos;
        }

        public boolean m_6542_(Player player) {
            return this.tileReference == null;
        }

        public ItemStack m_8020_(int slot) {
            if (this.tileReference != null) {
                return this.tileReference.m_8020_(slot);
            }
            return super.m_8020_(slot);
        }

        public ItemStack m_7407_(int slot, int amount) {
            if (this.tileReference != null) {
                return this.tileReference.m_7407_(slot, amount);
            }
            return super.m_7407_(slot, amount);
        }

        public boolean m_7983_() {
            if (this.tileReference != null) {
                return this.tileReference.m_7983_();
            }
            return super.m_7983_();
        }

        public ItemStack m_8016_(int slot) {
            if (this.tileReference != null) {
                return this.tileReference.m_8016_(slot);
            }
            return super.m_8016_(slot);
        }

        public void m_6211_() {
            if (this.tileReference != null) {
                this.tileReference.m_6211_();
            } else {
                super.m_6211_();
            }
        }

        public boolean m_7013_(int index, ItemStack stack) {
            if (this.tileReference != null) {
                return this.tileReference.m_7013_(index, stack);
            }
            return super.m_7013_(index, stack);
        }

        public int m_6893_() {
            if (this.tileReference != null) {
                return this.tileReference.m_6893_();
            }
            return 1;
        }

        public int[] m_7071_(Direction side) {
            if (this.tileReference != null) {
                return this.tileReference.m_7071_(side);
            }
            return new int[]{0};
        }

        public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
            if (this.tileReference != null) {
                return this.m_7157_(index, itemStack, direction);
            }
            return true;
        }

        public boolean m_7157_(int index, ItemStack stack, Direction direction) {
            if (this.tileReference != null) {
                return this.tileReference.m_7157_(index, stack, direction);
            }
            return !this.m_7983_();
        }

        public void m_6596_() {
            if (!this.m_7983_()) {
                BlockEntity blockEntity;
                ItemStack item = this.m_8020_(0);
                if (!item.m_41619_()) {
                    this.level.m_7731_(this.pos, (BlockState)this.state.m_61124_(ITEM_STATUS, (Comparable)((Object)ModBlockProperties.DisplayStatus.EMPTY)), 3);
                }
                if ((blockEntity = this.level.m_7702_(this.pos)) instanceof PedestalBlockTile) {
                    PedestalBlockTile tile;
                    this.tileReference = tile = (PedestalBlockTile)blockEntity;
                    tile.setDisplayedItem(item);
                }
            }
        }
    }
}

