/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.entities.IPartyCreeper;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class PartyHatLayer<E extends LivingEntity, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    protected final ModelPart string;
    protected final ModelPart parentHead;

    public PartyHatLayer(RenderLayerParent<E, M> renderer, EntityModelSet entityModels) {
        super(renderer);
        this.string = entityModels.m_171103_(ClientRegistry.PARTY_CREEPER_MODEL);
        this.parentHead = this.getParentHead(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, E entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.m_20145_() && this.hasHat(entity)) {
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110464_((ResourceLocation)ModTextures.PARTY_CREEPER));
            poseStack.m_85836_();
            this.string.m_104315_(this.parentHead);
            this.string.m_104301_(poseStack, vertexConsumer, packedLight, LivingEntityRenderer.m_115338_(entity, (float)0.0f));
            this.renderExtra(poseStack, buffer, packedLight, entity);
            poseStack.m_85849_();
        }
    }

    protected void renderExtra(PoseStack poseStack, MultiBufferSource buffer, int packedLight, E entity) {
    }

    protected abstract ModelPart getParentHead(RenderLayerParent<E, M> var1);

    protected abstract boolean hasHat(E var1);

    public static LayerDefinition createMesh() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, CubeDeformation.f_171458_), PartPose.f_171404_);
        if (PlatHelper.getPlatform().isFabric()) {
            partDefinition.m_171599_("hat_1", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-4.0f, -16.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(4.0f * Mth.m_14116_((float)2.0f) - 4.0f, 0.0f, 0.0f)), PartPose.m_171430_((float)0.0f, (float)0.7853982f, (float)0.0f));
            partDefinition.m_171599_("hat_2", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-4.0f, -16.0f, 0.0f, 8.0f, 9.0f, 0.0f, new CubeDeformation(4.0f * Mth.m_14116_((float)2.0f) - 4.0f, 0.0f, 0.0f)), PartPose.m_171430_((float)0.0f, (float)-0.7853982f, (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public static class Creeper<C extends net.minecraft.world.entity.monster.Creeper>
    extends PartyHatLayer<C, CreeperModel<C>> {
        private final ItemInHandRenderer itemRenderer;
        private final ItemStack stack;
        private final boolean rendersItem;

        public Creeper(RenderLayerParent<C, CreeperModel<C>> renderer, EntityModelSet entityModels, ItemInHandRenderer itemRenderer) {
            super(renderer, entityModels);
            this.itemRenderer = itemRenderer;
            this.stack = ModRegistry.CONFETTI_POPPER.get().m_7968_();
            this.rendersItem = PlatHelper.getPlatform().isForge();
        }

        @Override
        protected boolean hasHat(C livingEntity) {
            return ((IPartyCreeper)livingEntity).supplementaries$isFestive();
        }

        @Override
        protected ModelPart getParentHead(RenderLayerParent<C, CreeperModel<C>> renderer) {
            return ((CreeperModel)this.m_117386_()).m_142109_().m_171324_("head");
        }

        @Override
        protected void renderExtra(PoseStack poseStack, MultiBufferSource buffer, int packedLight, C entity) {
            if (this.rendersItem) {
                this.parentHead.m_104299_(poseStack);
                CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
                this.itemRenderer.m_269530_(entity, this.stack, ItemDisplayContext.HEAD, false, poseStack, buffer, packedLight);
            }
        }
    }

    public static class Generic<P extends LivingEntity>
    extends PartyHatLayer<P, HumanoidModel<P>> {
        public Generic(RenderLayerParent<P, HumanoidModel<P>> renderer, EntityModelSet entityModels) {
            super(renderer, entityModels);
        }

        @Override
        protected boolean hasHat(P livingEntity) {
            return livingEntity.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModRegistry.CONFETTI_POPPER.get();
        }

        @Override
        protected ModelPart getParentHead(RenderLayerParent<P, HumanoidModel<P>> renderer) {
            return ((HumanoidModel)this.m_117386_()).f_102808_;
        }
    }
}

