/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.common.fluid.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.FluidIngredient;
import java.util.List;

public class QuantifiedFluidIngredient
extends FluidIngredient {
    public static final Codec<QuantifiedFluidIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("ingredient").forGetter(QuantifiedFluidIngredient::getIngredient), (App)Codec.LONG.fieldOf("millibuckets").orElse((Object)1000L).forGetter(o -> FluidConstants.toMillibuckets(o.getFluidAmount()))).apply((Applicative)instance, (fluidIngredient, aLong) -> new QuantifiedFluidIngredient((FluidIngredient)fluidIngredient, FluidConstants.fromMillibuckets(aLong))));
    private final long fluidAmount;
    private final FluidIngredient ingredient;

    public QuantifiedFluidIngredient(FluidIngredient ingredient, long fluidAmount) {
        super(ingredient.getRawValues());
        this.ingredient = ingredient;
        this.fluidAmount = fluidAmount;
    }

    public long getFluidAmount() {
        return this.fluidAmount;
    }

    public FluidIngredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public boolean test(FluidHolder fluidHolder) {
        return this.ingredient.test(fluidHolder) && fluidHolder.getFluidAmount() >= this.fluidAmount;
    }

    @Override
    public List<FluidHolder> getFluids() {
        return this.ingredient.getFluids();
    }

    @Override
    public List<Either<FluidIngredient.FluidValue, FluidIngredient.TagValue>> getRawValues() {
        return this.ingredient.getRawValues();
    }
}

