/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelBlockEntity;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplayLayout;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

@GameTestGroup(path="items")
public class TestItems {
    @GameTest(template="andesite_tunnel_split")
    public static void andesiteTunnelSplit(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 6, 2);
        helper.m_177421_(lever);
        Map<BlockPos, ItemStack> outputs = Map.of(new BlockPos(2, 2, 1), new ItemStack((ItemLike)AllItems.BRASS_INGOT.get(), 1), new BlockPos(3, 2, 1), new ItemStack((ItemLike)AllItems.BRASS_INGOT.get(), 1), new BlockPos(4, 2, 2), new ItemStack((ItemLike)AllItems.BRASS_INGOT.get(), 3));
        helper.m_177361_(() -> outputs.forEach(helper::assertContainerContains));
    }

    @GameTest(template="arm_purgatory", timeoutTicks=200)
    public static void armPurgatory(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 2);
        BlockPos depot1Pos = new BlockPos(3, 2, 1);
        DepotBlockEntity depot1 = (DepotBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.DEPOT.get(), depot1Pos);
        BlockPos depot2Pos = new BlockPos(1, 2, 1);
        DepotBlockEntity depot2 = (DepotBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.DEPOT.get(), depot2Pos);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(5);
            ItemStack held1 = depot1.getHeldItem();
            boolean held1Empty = held1.m_41619_();
            int held1Count = held1.m_41613_();
            ItemStack held2 = depot2.getHeldItem();
            boolean held2Empty = held2.m_41619_();
            int held2Count = held2.m_41613_();
            if (held1Empty && held2Empty) {
                helper.m_177284_("No item present");
            }
            if (!held1Empty && held1Count != 1) {
                helper.m_177284_("Unexpected count on depot 1: " + held1Count);
            }
            if (!held2Empty && held2Count != 1) {
                helper.m_177284_("Unexpected count on depot 2: " + held2Count);
            }
        });
    }

    @GameTest(template="attribute_filters", timeoutTicks=200)
    public static void attributeFilters(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 1);
        BlockPos end = new BlockPos(11, 2, 2);
        Map<BlockPos, ItemStack> outputs = Map.of(new BlockPos(3, 2, 1), new ItemStack((ItemLike)AllBlocks.BRASS_BLOCK.get()), new BlockPos(4, 2, 1), new ItemStack((ItemLike)Items.f_42410_), new BlockPos(5, 2, 1), new ItemStack((ItemLike)Items.f_42447_), new BlockPos(6, 2, 1), EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(Enchantments.f_44965_, 1)), new BlockPos(7, 2, 1), (ItemStack)Util.m_137469_((Object)new ItemStack((ItemLike)Items.f_42393_), s -> s.m_41721_(1)), new BlockPos(8, 2, 1), new ItemStack((ItemLike)Items.f_42468_), new BlockPos(9, 2, 1), new ItemStack((ItemLike)Items.f_42413_), new BlockPos(10, 2, 1), new ItemStack((ItemLike)Items.f_42620_));
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            outputs.forEach(helper::assertContainerContains);
            helper.m_177440_(end);
        });
    }

    @GameTest(template="belt_coaster", timeoutTicks=200)
    public static void beltCoaster(CreateGameTestHelper helper) {
        BlockPos input = new BlockPos(1, 5, 6);
        BlockPos output = new BlockPos(3, 8, 6);
        BlockPos lever = new BlockPos(1, 5, 5);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            long remainingItems;
            long outputItems = helper.getTotalItems(output);
            if (outputItems != 27L) {
                helper.m_177284_("Expected 27 items, got " + outputItems);
            }
            if ((remainingItems = helper.getTotalItems(input)) != 2L) {
                helper.m_177284_("Expected 2 items remaining, got " + remainingItems);
            }
        });
    }

    @GameTest(template="brass_tunnel_filtering")
    public static void brassTunnelFiltering(CreateGameTestHelper helper) {
        Map<BlockPos, ItemStack> outputs = Map.of(new BlockPos(3, 2, 2), new ItemStack((ItemLike)Items.f_151052_, 13), new BlockPos(4, 2, 3), new ItemStack((ItemLike)AllItems.ZINC_INGOT.get(), 4), new BlockPos(4, 2, 4), new ItemStack((ItemLike)Items.f_42416_, 2), new BlockPos(4, 2, 5), new ItemStack((ItemLike)Items.f_42417_, 24), new BlockPos(3, 2, 6), new ItemStack((ItemLike)Items.f_42415_, 17));
        BlockPos lever = new BlockPos(2, 3, 2);
        helper.m_177421_(lever);
        helper.m_177361_(() -> outputs.forEach(helper::assertContainerContains));
    }

    @GameTest(template="brass_tunnel_prefer_nearest", timeoutTicks=200)
    public static void brassTunnelPreferNearest(CreateGameTestHelper helper) {
        List<BlockPos> tunnels = List.of(new BlockPos(3, 3, 1), new BlockPos(3, 3, 2), new BlockPos(3, 3, 3));
        List<BlockPos> out = List.of(new BlockPos(5, 2, 1), new BlockPos(5, 2, 2), new BlockPos(5, 2, 3));
        BlockPos lever = new BlockPos(2, 3, 2);
        helper.m_177421_(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((BlockPos)tunnel, BrassTunnelBlockEntity.SelectionMode.PREFER_NEAREST));
        helper.m_177361_(() -> out.forEach(pos -> helper.assertContainerContains((BlockPos)pos, (ItemLike)AllBlocks.BRASS_CASING.get())));
    }

    @GameTest(template="brass_tunnel_round_robin", timeoutTicks=200)
    public static void brassTunnelRoundRobin(CreateGameTestHelper helper) {
        List<BlockPos> outputs = List.of(new BlockPos(7, 3, 1), new BlockPos(7, 3, 2), new BlockPos(7, 3, 3));
        TestItems.brassTunnelModeTest(helper, BrassTunnelBlockEntity.SelectionMode.ROUND_ROBIN, outputs);
    }

    @GameTest(template="brass_tunnel_split")
    public static void brassTunnelSplit(CreateGameTestHelper helper) {
        List<BlockPos> outputs = List.of(new BlockPos(7, 2, 1), new BlockPos(7, 2, 2), new BlockPos(7, 2, 3));
        TestItems.brassTunnelModeTest(helper, BrassTunnelBlockEntity.SelectionMode.SPLIT, outputs);
    }

    private static void brassTunnelModeTest(CreateGameTestHelper helper, BrassTunnelBlockEntity.SelectionMode mode, List<BlockPos> outputs) {
        BlockPos lever = new BlockPos(2, 3, 2);
        List<BlockPos> tunnels = List.of(new BlockPos(3, 3, 1), new BlockPos(3, 3, 2), new BlockPos(3, 3, 3));
        helper.m_177421_(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((BlockPos)tunnel, mode));
        helper.m_177361_(() -> {
            long items = 0L;
            for (BlockPos out : outputs) {
                helper.assertContainerContains(out, (ItemLike)AllBlocks.BRASS_CASING.get());
                items += helper.getTotalItems(out);
            }
            if (items != 10L) {
                helper.m_177284_("expected 10 items, got " + items);
            }
        });
    }

    @GameTest(template="brass_tunnel_sync_input", timeoutTicks=200)
    public static void brassTunnelSyncInput(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(1, 3, 2);
        List<BlockPos> redstoneBlocks = List.of(new BlockPos(3, 4, 1), new BlockPos(3, 4, 2), new BlockPos(3, 4, 3));
        List<BlockPos> tunnels = List.of(new BlockPos(5, 3, 1), new BlockPos(5, 3, 2), new BlockPos(5, 3, 3));
        List<BlockPos> outputs = List.of(new BlockPos(7, 2, 1), new BlockPos(7, 2, 2), new BlockPos(7, 2, 3));
        helper.m_177421_(lever);
        tunnels.forEach(tunnel -> helper.setTunnelMode((BlockPos)tunnel, BrassTunnelBlockEntity.SelectionMode.SYNCHRONIZE));
        helper.m_177361_(() -> {
            if (helper.secondsPassed() < 9L) {
                helper.m_177245_((BlockPos)redstoneBlocks.get(0), Blocks.f_50016_);
                helper.assertSecondsPassed(3);
                outputs.forEach(helper::m_177440_);
                helper.m_177245_((BlockPos)redstoneBlocks.get(1), Blocks.f_50016_);
                helper.assertSecondsPassed(6);
                outputs.forEach(helper::m_177440_);
                helper.m_177245_((BlockPos)redstoneBlocks.get(2), Blocks.f_50016_);
                helper.assertSecondsPassed(9);
            } else {
                outputs.forEach(out -> helper.assertContainerContains((BlockPos)out, (ItemLike)AllBlocks.BRASS_CASING.get()));
            }
        });
    }

    @GameTest(template="smart_observer_belt_and_funnel", timeoutTicks=200)
    public static void smartObserverBeltAndFunnel(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(6, 3, 2);
        List<BlockPos> targets = List.of(new BlockPos(5, 2, 1), new BlockPos(2, 4, 6));
        List<BlockPos> overflows = List.of(new BlockPos(6, 2, 1), new BlockPos(1, 3, 6));
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(9);
            targets.forEach(pos -> helper.m_177208_(Blocks.f_50090_, (BlockPos)pos));
            overflows.forEach(pos -> helper.m_177208_(Blocks.f_50016_, (BlockPos)pos));
        });
    }

    @GameTest(template="smart_observer_chutes")
    public static void smartObserverChutes(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(1, 5, 2);
        BlockPos output = new BlockPos(1, 5, 3);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177208_(Blocks.f_50090_, output));
    }

    @GameTest(template="smart_observer_counting")
    public static void smartObserverCounting(CreateGameTestHelper helper) {
        BlockPos chest = new BlockPos(3, 2, 1);
        long totalChestItems = helper.getTotalItems(chest);
        BlockPos chestNixiePos = new BlockPos(2, 3, 1);
        NixieTubeBlockEntity chestNixie = (NixieTubeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get(), chestNixiePos);
        BlockPos doubleChest = new BlockPos(2, 2, 3);
        long totalDoubleChestItems = helper.getTotalItems(doubleChest);
        BlockPos doubleChestNixiePos = new BlockPos(1, 3, 3);
        NixieTubeBlockEntity doubleChestNixie = (NixieTubeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.NIXIE_TUBE.get(), doubleChestNixiePos);
        helper.m_177361_(() -> {
            String doubleChestNixieText;
            long doubleChestNixieReading;
            String chestNixieText = chestNixie.getFullText().getString();
            long chestNixieReading = Long.parseLong(chestNixieText);
            if (chestNixieReading != totalChestItems) {
                helper.m_177284_("Chest nixie detected %s, expected %s".formatted(chestNixieReading, totalChestItems));
            }
            if ((doubleChestNixieReading = Long.parseLong(doubleChestNixieText = doubleChestNixie.getFullText().getString())) != totalDoubleChestItems) {
                helper.m_177284_("Double chest nixie detected %s, expected %s".formatted(doubleChestNixieReading, totalDoubleChestItems));
            }
        });
    }

    @GameTest(template="smart_observer_filtered_storage")
    public static void smartObserverFilteredStorage(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 3, 1);
        BlockPos leftLamp = new BlockPos(3, 2, 3);
        BlockPos rightLamp = new BlockPos(1, 2, 3);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.m_177255_(leftLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
            helper.m_177255_(rightLamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
        });
    }

    @GameTest(template="smart_observer_storage")
    public static void smartObserverStorage(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(1, 3, 2);
        BlockPos lamp = new BlockPos(1, 2, 3);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true)));
    }

    @GameTest(template="depot_display", timeoutTicks=200)
    public static void depotDisplay(CreateGameTestHelper helper) {
        BlockPos displayPos = new BlockPos(5, 3, 1);
        List<DepotBlockEntity> depots = Stream.of(new BlockPos(2, 2, 1), new BlockPos(1, 2, 1)).map(pos -> (DepotBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.DEPOT.get(), (BlockPos)pos)).toList();
        List<BlockPos> levers = List.of(new BlockPos(2, 5, 0), new BlockPos(1, 5, 0));
        levers.forEach(arg_0 -> ((CreateGameTestHelper)helper).m_177421_(arg_0));
        FlapDisplayBlockEntity display = ((FlapDisplayBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.FLAP_DISPLAY.get(), displayPos)).getController();
        helper.m_177361_(() -> {
            for (int i = 0; i < 2; ++i) {
                FlapDisplayLayout line = display.getLines().get(i);
                MutableComponent textComponent = Component.m_237119_();
                line.getSections().stream().map(FlapDisplaySection::getText).forEach(arg_0 -> ((MutableComponent)textComponent).m_7220_(arg_0));
                String text = textComponent.getString().toLowerCase(Locale.ROOT).trim();
                DepotBlockEntity depot = (DepotBlockEntity)depots.get(i);
                ItemStack item = depot.getHeldItem();
                String name = ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).m_135815_();
                if (name.equals(text)) continue;
                helper.m_177284_("Text mismatch: wanted [" + name + "], got: " + text);
            }
        });
    }

    @GameTest(template="threshold_switch")
    public static void thresholdSwitch(CreateGameTestHelper helper) {
        BlockPos chest = new BlockPos(1, 2, 1);
        BlockPos lamp = new BlockPos(2, 3, 1);
        helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(false));
        IItemHandler chestStorage = helper.itemStorageAt(chest);
        for (int i = 0; i < 18; ++i) {
            ItemHandlerHelper.insertItem((IItemHandler)chestStorage, (ItemStack)new ItemStack((ItemLike)Items.f_42415_, 64), (boolean)false);
        }
        helper.m_177361_(() -> helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true)));
    }

    @GameTest(template="storages", timeoutTicks=200)
    public static void storages(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(12, 3, 2);
        BlockPos startChest = new BlockPos(13, 3, 1);
        Object2LongMap<Item> originalContent = helper.getItemContent(startChest);
        BlockPos endShulker = new BlockPos(1, 3, 1);
        helper.m_177421_(lever);
        helper.m_177361_(() -> helper.assertContentPresent(originalContent, endShulker));
    }

    @GameTest(template="vault_comparator_output")
    public static void vaultComparatorOutput(CreateGameTestHelper helper) {
        BlockPos smallInput = new BlockPos(1, 4, 1);
        BlockPos smallNixie = new BlockPos(3, 2, 1);
        helper.assertNixiePower(smallNixie, 0);
        helper.whenSecondsPassed(1, () -> helper.spawnItems(smallInput, Items.f_42406_, 576));
        BlockPos medInput = new BlockPos(1, 5, 4);
        BlockPos medNixie = new BlockPos(4, 2, 4);
        helper.assertNixiePower(medNixie, 0);
        helper.whenSecondsPassed(2, () -> helper.spawnItems(medInput, Items.f_42406_, 4928));
        BlockPos bigInput = new BlockPos(1, 6, 8);
        BlockPos bigNixie = new BlockPos(5, 2, 7);
        helper.assertNixiePower(bigNixie, 0);
        helper.whenSecondsPassed(3, () -> helper.spawnItems(bigInput, Items.f_42406_, 15360));
        helper.m_177361_(() -> {
            helper.assertNixiePower(smallNixie, 7);
            helper.assertNixiePower(medNixie, 7);
            helper.assertNixiePower(bigNixie, 7);
        });
    }

    @GameTest(template="depot_comparator_output")
    public static void depotComparatorOutput(CreateGameTestHelper helper) {
        BlockPos swordNixie = new BlockPos(7, 2, 1);
        BlockPos diamondNixie = new BlockPos(5, 2, 1);
        BlockPos fullPearlNixie = new BlockPos(3, 2, 1);
        BlockPos halfPearlNixie = new BlockPos(1, 2, 1);
        helper.m_177361_(() -> {
            helper.assertNixiePower(swordNixie, 15);
            helper.assertNixiePower(diamondNixie, 15);
            helper.assertNixiePower(fullPearlNixie, 15);
            helper.assertNixiePower(halfPearlNixie, 8);
        });
    }

    @GameTest(template="fan_processing", timeoutTicks=200)
    public static void fanProcessing(CreateGameTestHelper helper) {
        BlockPos.m_121940_((BlockPos)new BlockPos(2, 7, 3), (BlockPos)new BlockPos(11, 7, 3)).forEach(pos -> helper.m_177245_((BlockPos)pos, Blocks.f_50088_));
        helper.m_177302_(1, 7, 3);
        List<BlockPos> lamps = List.of(new BlockPos(1, 2, 1), new BlockPos(5, 2, 1), new BlockPos(7, 2, 1), new BlockPos(9, 2, 1), new BlockPos(11, 2, 1));
        helper.m_177361_(() -> {
            for (BlockPos lamp : lamps) {
                helper.m_177255_(lamp, (Property)RedstoneLampBlock.f_55654_, Boolean.valueOf(true));
            }
        });
    }
}

