/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.pack;

import com.google.gson.JsonElement;
import com.simibubi.create.Create;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicPack
implements PackResources {
    private final Map<String, IoSupplier<InputStream>> files = new HashMap<String, IoSupplier<InputStream>>();
    private final String packId;
    private final PackType packType;
    private final PackMetadataSection metadata;

    public DynamicPack(String packId, PackType packType) {
        this.packId = packId;
        this.packType = packType;
        this.metadata = new PackMetadataSection((Component)Component.m_237119_(), SharedConstants.m_183709_().m_264084_(packType));
    }

    private static String getPath(PackType packType, ResourceLocation resourceLocation) {
        return packType.m_10305_() + "/" + resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_();
    }

    public DynamicPack put(ResourceLocation location, IoSupplier<InputStream> stream) {
        this.files.put(DynamicPack.getPath(this.packType, location), stream);
        return this;
    }

    public DynamicPack put(ResourceLocation location, byte[] bytes) {
        return this.put(location, (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(bytes)));
    }

    public DynamicPack put(ResourceLocation location, String string) {
        return this.put(location, string.getBytes(StandardCharsets.UTF_8));
    }

    public DynamicPack put(ResourceLocation location, JsonElement json) {
        return this.put(location.m_266382_(".json"), Create.GSON.toJson(json));
    }

    @Nullable
    public IoSupplier<InputStream> m_8017_(String ... elements) {
        return this.files.getOrDefault(String.join((CharSequence)"/", elements), null);
    }

    @Nullable
    public IoSupplier<InputStream> m_214146_(@NotNull PackType packType, @NotNull ResourceLocation resourceLocation) {
        return this.files.getOrDefault(DynamicPack.getPath(packType, resourceLocation), null);
    }

    public void m_8031_(@NotNull PackType packType, @NotNull String namespace, @NotNull String path, @NotNull PackResources.ResourceOutput resourceOutput) {
        ResourceLocation resourceLocation = new ResourceLocation(namespace, path);
        String directoryAndNamespace = packType.m_10305_() + "/" + namespace + "/";
        String prefix = directoryAndNamespace + path + "/";
        this.files.forEach((filePath, streamSupplier) -> {
            if (filePath.startsWith(prefix)) {
                resourceOutput.accept((Object)resourceLocation.m_247449_(filePath.substring(directoryAndNamespace.length())), streamSupplier);
            }
        });
    }

    @NotNull
    public Set<String> m_5698_(PackType packType) {
        HashSet<String> namespaces = new HashSet<String>();
        String dir = packType.m_10305_() + "/";
        for (String path : this.files.keySet()) {
            String relative;
            if (!path.startsWith(dir) || !(relative = path.substring(dir.length())).contains("/")) continue;
            namespaces.add(relative.substring(0, relative.indexOf("/")));
        }
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(@NotNull MetadataSectionSerializer<T> deserializer) throws IOException {
        return (T)(deserializer == PackMetadataSection.f_243696_ ? this.metadata : null);
    }

    @NotNull
    public String m_5542_() {
        return this.packId;
    }

    public void close() {
    }
}

