/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.graph;

import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class DimensionPalette {
    List<ResourceKey<Level>> gatheredDims = new ArrayList<ResourceKey<Level>>();

    public int encode(ResourceKey<Level> dimension) {
        int indexOf = this.gatheredDims.indexOf(dimension);
        if (indexOf == -1) {
            indexOf = this.gatheredDims.size();
            this.gatheredDims.add(dimension);
        }
        return indexOf;
    }

    public ResourceKey<Level> decode(int index) {
        if (this.gatheredDims.size() <= index || index < 0) {
            return Level.f_46428_;
        }
        return this.gatheredDims.get(index);
    }

    public void send(FriendlyByteBuf buffer) {
        buffer.writeInt(this.gatheredDims.size());
        this.gatheredDims.forEach(rk -> buffer.m_130085_(rk.m_135782_()));
    }

    public static DimensionPalette receive(FriendlyByteBuf buffer) {
        DimensionPalette palette = new DimensionPalette();
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            palette.gatheredDims.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)buffer.m_130281_()));
        }
        return palette;
    }

    public void write(CompoundTag tag) {
        tag.m_128365_("DimensionPalette", (Tag)NBTHelper.writeCompoundList(this.gatheredDims, rk -> {
            CompoundTag c = new CompoundTag();
            c.m_128359_("Id", rk.m_135782_().toString());
            return c;
        }));
    }

    public static DimensionPalette read(CompoundTag tag) {
        DimensionPalette palette = new DimensionPalette();
        NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("DimensionPalette", 10), c -> palette.gatheredDims.add((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(c.m_128461_("Id")))));
        return palette;
    }
}

