/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.utility.CreateLang;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public abstract class ClickToLinkBlockItem
extends BlockItem {
    private static BlockPos lastShownPos = null;
    private static AABB lastShownAABB = null;

    public ClickToLinkBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    @SubscribeEvent
    public static void linkableItemAlwaysPlacesWhenUsed(PlayerInteractEvent.RightClickBlock event) {
        ItemStack usedItem = event.getItemStack();
        Item item = usedItem.m_41720_();
        if (!(item instanceof ClickToLinkBlockItem)) {
            return;
        }
        ClickToLinkBlockItem blockItem = (ClickToLinkBlockItem)item;
        if (event.getLevel().m_8055_(event.getPos()).m_60713_(blockItem.m_40614_())) {
            return;
        }
        event.setUseBlock(Event.Result.DENY);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = pContext.m_43723_();
        String msgKey = this.getMessageTranslationKey();
        int maxDistance = this.getMaxDistanceFromSelection();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.m_6144_() && stack.m_41782_()) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)CreateLang.translateDirect(msgKey + ".clear", new Object[0]), true);
            stack.m_41751_(null);
            return InteractionResult.SUCCESS;
        }
        String placedDim = level.m_46472_().m_135782_().toString();
        if (!stack.m_41782_()) {
            if (!this.isValidTarget((LevelAccessor)level, pos)) {
                if (this.placeWhenInvalid()) {
                    InteractionResult useOn = super.m_6225_(pContext);
                    if (level.f_46443_ || useOn == InteractionResult.FAIL) {
                        return useOn;
                    }
                    ItemStack itemInHand = player.m_21120_(pContext.m_43724_());
                    if (!itemInHand.m_41619_()) {
                        itemInHand.m_41751_(null);
                    }
                    return useOn;
                }
                if (level.f_46443_) {
                    AllSoundEvents.DENY.playFrom((Entity)player);
                }
                player.m_5661_((Component)CreateLang.translateDirect(msgKey + ".invalid", new Object[0]), true);
                return InteractionResult.FAIL;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            CompoundTag stackTag = stack.m_41784_();
            stackTag.m_128365_("SelectedPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            stackTag.m_128359_("SelectedDimension", placedDim);
            player.m_5661_((Component)CreateLang.translateDirect(msgKey + ".set", new Object[0]), true);
            stack.m_41751_(stackTag);
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.m_41783_();
        CompoundTag teTag = new CompoundTag();
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("SelectedPos"));
        String selectedDim = tag.m_128461_("SelectedDimension");
        BlockPos placedPos = pos.m_5484_(pContext.m_43719_(), state.m_247087_() ? 0 : 1);
        if (!(maxDistance == -1 || selectedPos.m_123314_((Vec3i)placedPos, (double)maxDistance) && selectedDim.equals(placedDim))) {
            player.m_5661_((Component)CreateLang.translateDirect(msgKey + ".too_far", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        teTag.m_128365_("TargetOffset", (Tag)NbtUtils.m_129224_((BlockPos)selectedPos.m_121996_((Vec3i)placedPos)));
        teTag.m_128359_("TargetDimension", selectedDim);
        tag.m_128365_("BlockEntityTag", (Tag)teTag);
        InteractionResult useOn = super.m_6225_(pContext);
        if (level.f_46443_ || useOn == InteractionResult.FAIL) {
            return useOn;
        }
        ItemStack itemInHand = player.m_21120_(pContext.m_43724_());
        if (!itemInHand.m_41619_()) {
            itemInHand.m_41751_(null);
        }
        player.m_5661_((Component)CreateLang.translateDirect(msgKey + ".success", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
        return useOn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack heldItemMainhand = player.m_21205_();
        Item item = heldItemMainhand.m_41720_();
        if (!(item instanceof ClickToLinkBlockItem)) {
            return;
        }
        ClickToLinkBlockItem blockItem = (ClickToLinkBlockItem)item;
        if (!heldItemMainhand.m_41782_()) {
            return;
        }
        CompoundTag stackTag = heldItemMainhand.m_41784_();
        if (!stackTag.m_128441_("SelectedPos")) {
            return;
        }
        BlockPos selectedPos = NbtUtils.m_129239_((CompoundTag)stackTag.m_128469_("SelectedPos"));
        if (!selectedPos.equals((Object)lastShownPos)) {
            lastShownAABB = blockItem.getSelectionBounds(selectedPos);
            lastShownPos = selectedPos;
        }
        Outliner.getInstance().showAABB((Object)"target", lastShownAABB).colored(16763764).lineWidth(0.0625f);
    }

    public abstract int getMaxDistanceFromSelection();

    public abstract String getMessageTranslationKey();

    public boolean placeWhenInvalid() {
        return false;
    }

    public boolean isValidTarget(LevelAccessor level, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getSelectionBounds(BlockPos pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockState state = world.m_8055_(pos);
        VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
        return shape.m_83281_() ? new AABB(BlockPos.f_121853_) : shape.m_83215_().m_82338_(pos);
    }
}

