/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagerLink;

import com.google.common.cache.Cache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import com.simibubi.create.content.logistics.packager.PackagingRequest;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.foundation.utility.TickBasedCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Pair;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class LogisticsManager {
    private static Random r = new Random();
    public static final Cache<UUID, InventorySummary> ACCURATE_SUMMARIES = new TickBasedCache<UUID, InventorySummary>(1, false);
    public static final Cache<UUID, InventorySummary> SUMMARIES = new TickBasedCache<UUID, InventorySummary>(20, false);

    public static InventorySummary getSummaryOfNetwork(UUID freqId, boolean accurate) {
        try {
            return (InventorySummary)(accurate ? ACCURATE_SUMMARIES : SUMMARIES).get((Object)freqId, () -> {
                InventorySummary summaryOfLinks = new InventorySummary();
                LogisticallyLinkedBehaviour.getAllPresent(freqId, false).forEach(link -> {
                    InventorySummary summary = link.getSummary(null);
                    if (summary != InventorySummary.EMPTY) {
                        ++summaryOfLinks.contributingLinks;
                    }
                    summaryOfLinks.add(summary);
                });
                return summaryOfLinks;
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return InventorySummary.EMPTY;
        }
    }

    public static int getStockOf(UUID freqId, ItemStack stack, @Nullable IdentifiedInventory ignoredHandler) {
        int sum = 0;
        for (LogisticallyLinkedBehaviour link : LogisticallyLinkedBehaviour.getAllPresent(freqId, false)) {
            sum += link.getSummary(ignoredHandler).getCountOf(stack);
        }
        return sum;
    }

    public static boolean broadcastPackageRequest(UUID freqId, LogisticallyLinkedBehaviour.RequestType type, PackageOrderWithCrafts order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        if (order.isEmpty()) {
            return false;
        }
        Multimap<PackagerBlockEntity, PackagingRequest> requests = LogisticsManager.findPackagersForRequest(freqId, order, ignoredHandler, address);
        for (PackagerBlockEntity packager : requests.keySet()) {
            if (!packager.isTooBusyFor(type)) continue;
            return false;
        }
        LogisticsManager.performPackageRequests(requests);
        return true;
    }

    public static Multimap<PackagerBlockEntity, PackagingRequest> findPackagersForRequest(UUID freqId, PackageOrderWithCrafts order, @Nullable IdentifiedInventory ignoredHandler, String address) {
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>();
        for (BigItemStack stack : order.stacks()) {
            if (stack.stack.m_41619_() || stack.count <= 0) continue;
            stacks.add(stack);
        }
        HashMultimap requests = HashMultimap.create();
        Collection<LogisticallyLinkedBehaviour> availableLinks = LogisticallyLinkedBehaviour.getAllPresent(freqId, true);
        ArrayList<LogisticallyLinkedBehaviour> usedLinks = new ArrayList<LogisticallyLinkedBehaviour>();
        MutableBoolean finalLinkTracker = new MutableBoolean(false);
        PackageOrderWithCrafts context = order;
        int orderId = r.nextInt();
        block1: for (int i = 0; i < stacks.size(); ++i) {
            BigItemStack entry = (BigItemStack)stacks.get(i);
            int remainingCount = entry.count;
            boolean finalEntry = i == stacks.size() - 1;
            ItemStack requestedItem = entry.stack;
            for (LogisticallyLinkedBehaviour link : availableLinks) {
                Pair<PackagerBlockEntity, PackagingRequest> request;
                int usedIndex = usedLinks.indexOf(link);
                int linkIndex = usedIndex == -1 ? usedLinks.size() : usedIndex;
                MutableBoolean isFinalLink = new MutableBoolean(false);
                if (linkIndex == usedLinks.size() - 1) {
                    isFinalLink = finalLinkTracker;
                }
                if ((request = link.processRequest(requestedItem, remainingCount, address, linkIndex, isFinalLink, orderId, context, ignoredHandler)) == null) continue;
                requests.put((Object)((PackagerBlockEntity)request.getFirst()), (Object)((PackagingRequest)request.getSecond()));
                int processedCount = ((PackagingRequest)request.getSecond()).getCount();
                if (processedCount > 0 && usedIndex == -1) {
                    context = null;
                    usedLinks.add(link);
                    finalLinkTracker = isFinalLink;
                }
                if ((remainingCount -= processedCount) > 0) continue;
                if (!finalEntry) continue block1;
                finalLinkTracker.setTrue();
                continue block1;
            }
        }
        return requests;
    }

    public static void performPackageRequests(Multimap<PackagerBlockEntity, PackagingRequest> requests) {
        Map asMap = requests.asMap();
        for (Map.Entry entry : asMap.entrySet()) {
            ArrayList<PackagingRequest> queuedRequests = new ArrayList<PackagingRequest>((Collection)entry.getValue());
            PackagerBlockEntity packager = (PackagerBlockEntity)entry.getKey();
            if (!queuedRequests.isEmpty()) {
                packager.flashLink();
            }
            for (int i = 0; i < 100 && !queuedRequests.isEmpty(); ++i) {
                packager.attemptToSend(queuedRequests);
            }
            packager.triggerStockCheck();
            packager.notifyUpdate();
        }
    }
}

