/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packager;

import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class PackagerItemHandler
implements IItemHandlerModifiable {
    private PackagerBlockEntity blockEntity;

    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.blockEntity.heldBox;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        this.blockEntity.heldBox = stack;
        this.blockEntity.notifyUpdate();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.blockEntity.heldBox.m_41619_() || !this.blockEntity.queuedExitingPackages.isEmpty()) {
            return stack;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        if (!this.blockEntity.unwrapBox(stack, true)) {
            return stack;
        }
        if (!simulate) {
            this.blockEntity.unwrapBox(stack, false);
            this.blockEntity.triggerStockCheck();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.blockEntity.animationTicks != 0) {
            return ItemStack.f_41583_;
        }
        ItemStack box = this.blockEntity.heldBox;
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return box;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return PackageItem.isPackage(stack);
    }
}

