/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.packagePort.frogport;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.packagePort.PackagePortBlockEntity;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportSounds;
import com.simibubi.create.content.logistics.packager.PackagerItemHandler;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.TooltipHelper;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FrogportBlockEntity
extends PackagePortBlockEntity
implements IHaveHoveringInformation {
    public ItemStack animatedPackage;
    public LerpedFloat manualOpenAnimationProgress;
    public LerpedFloat animationProgress;
    public LerpedFloat anticipationProgress;
    public boolean currentlyDepositing;
    public boolean goggles = false;
    public boolean sendAnticipate;
    public float passiveYaw;
    private boolean failedLastExport;
    private FrogportSounds sounds = new FrogportSounds();
    private ItemStack deferAnimationStart;
    private boolean deferAnimationInward;
    private AdvancementBehaviour advancements;

    public FrogportBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.animationProgress = LerpedFloat.linear();
        this.anticipationProgress = LerpedFloat.linear();
        this.manualOpenAnimationProgress = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.35, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.advancements = new AdvancementBehaviour(this, AllAdvancements.FROGPORT);
        behaviours.add(this.advancements);
        super.addBehaviours(behaviours);
    }

    public boolean isAnimationInProgress() {
        return this.animationProgress.getChaseTarget() == 1.0f;
    }

    @Override
    public AABB getRenderBoundingBox() {
        AABB bb = super.getRenderBoundingBox().m_82363_(0.0, 1.0, 0.0);
        if (this.target != null) {
            bb = bb.m_82367_(new AABB(BlockPos.m_274446_((Position)this.target.getExactTargetLocation(this, (LevelAccessor)this.f_58857_, this.f_58858_)))).m_82400_(0.5);
        }
        return bb;
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_() || this.isAnimationInProgress()) {
            return;
        }
        boolean prevFail = this.failedLastExport;
        this.tryPushingToAdjacentInventories();
        this.tryPullingFromOwnAndAdjacentInventories();
        if (this.failedLastExport != prevFail) {
            this.sendData();
        }
    }

    public void sendAnticipate() {
        if (this.isAnimationInProgress()) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).m_41619_()) continue;
            this.sendAnticipate = true;
            this.sendData();
            return;
        }
    }

    public void anticipate() {
        this.anticipationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.deferAnimationStart != null) {
            this.startAnimation(this.deferAnimationStart, this.deferAnimationInward);
            this.deferAnimationStart = null;
        }
        if (this.anticipationProgress.getValue() == 1.0f) {
            this.anticipationProgress.startWithValue(0.0);
        }
        this.manualOpenAnimationProgress.updateChaseTarget(this.openTracker.openCount > 0 ? 1.0f : 0.0f);
        boolean wasOpen = this.manualOpenAnimationProgress.getValue() > 0.0f;
        this.anticipationProgress.tickChaser();
        this.manualOpenAnimationProgress.tickChaser();
        if (this.f_58857_.m_5776_() && wasOpen && this.manualOpenAnimationProgress.getValue() == 0.0f) {
            this.sounds.close(this.f_58857_, this.f_58858_);
        }
        if (!this.isAnimationInProgress()) {
            return;
        }
        this.animationProgress.tickChaser();
        float value = this.animationProgress.getValue();
        if (this.currentlyDepositing) {
            if (!this.f_58857_.m_5776_() || this.isVirtual()) {
                if ((double)value > 0.5 && this.animatedPackage != null) {
                    if (this.target == null || !this.target.depositImmediately() && !this.target.export((LevelAccessor)this.f_58857_, this.f_58858_, this.animatedPackage, false)) {
                        this.drop(this.animatedPackage);
                    }
                    this.animatedPackage = null;
                }
            } else {
                if ((double)value > 0.7 && this.animatedPackage != null) {
                    this.animatedPackage = null;
                }
                if ((double)this.animationProgress.getValue(0.0f) < 0.2 && (double)value > 0.2) {
                    Vec3 v = this.target.getExactTargetLocation(this, (LevelAccessor)this.f_58857_, this.f_58858_);
                    this.f_58857_.m_7785_(v.f_82479_, v.f_82480_, v.f_82481_, SoundEvents.f_11746_, SoundSource.BLOCKS, 0.25f, 1.2f, false);
                }
            }
        }
        if (value < 1.0f) {
            return;
        }
        this.anticipationProgress.startWithValue(0.0);
        this.animationProgress.startWithValue(0.0);
        if (this.f_58857_.m_5776_()) {
            this.animatedPackage = null;
            return;
        }
        if (!this.currentlyDepositing && !ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)this.animatedPackage.m_41777_(), (boolean)false).m_41619_()) {
            this.drop(this.animatedPackage);
        }
        this.animatedPackage = null;
    }

    public void startAnimation(ItemStack box, boolean deposit) {
        if (!PackageItem.isPackage(box)) {
            return;
        }
        if (deposit && (this.target == null || this.target.depositImmediately() && !this.target.export((LevelAccessor)this.f_58857_, this.f_58858_, box.m_41777_(), false))) {
            return;
        }
        this.animationProgress.startWithValue(0.0);
        this.animationProgress.chase(1.0, 0.1, LerpedFloat.Chaser.LINEAR);
        this.animatedPackage = box;
        this.currentlyDepositing = deposit;
        if (this.f_58857_ != null && !deposit && !this.f_58857_.m_5776_()) {
            this.advancements.awardPlayer(AllAdvancements.FROGPORT);
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.sounds.open(this.f_58857_, this.f_58858_);
            if (this.currentlyDepositing) {
                this.sounds.depositPackage(this.f_58857_, this.f_58858_);
            } else {
                this.sounds.catchPackage(this.f_58857_, this.f_58858_);
                Vec3 vec = this.target.getExactTargetLocation(this, (LevelAccessor)this.f_58857_, this.f_58858_);
                if (vec != null) {
                    for (int i = 0; i < 5; ++i) {
                        this.f_58857_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, AllBlocks.ROPE.getDefaultState()), vec.f_82479_, vec.f_82480_ - (double)this.f_58857_.f_46441_.m_188501_() * 0.25, vec.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_151543_(this.f_58858_);
            this.sendData();
        }
    }

    protected void tryPushingToAdjacentInventories() {
        this.failedLastExport = false;
        IItemHandler inventory = (IItemHandler)this.itemHandler.orElse(null);
        if (inventory == null) {
            return;
        }
        boolean empty = true;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).m_41619_()) continue;
            empty = false;
        }
        if (empty) {
            return;
        }
        IItemHandler handler = this.getAdjacentInventory(Direction.DOWN);
        if (handler == null) {
            return;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.extractItem(i, 1, true);
            if (stackInSlot.m_41619_()) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stackInSlot, (boolean)false);
            if (remainder.m_41619_()) {
                inventory.extractItem(i, 1, false);
                this.f_58857_.m_151543_(this.f_58858_);
                continue;
            }
            this.failedLastExport = true;
        }
    }

    @Override
    protected void onOpenChange(boolean open) {
    }

    public void tryPullingFromOwnAndAdjacentInventories() {
        if (this.isAnimationInProgress()) {
            return;
        }
        if (this.target == null || !this.target.export((LevelAccessor)this.f_58857_, this.f_58858_, PackageStyles.getDefaultBox(), true)) {
            return;
        }
        if (this.tryPullingFrom((IItemHandler)this.inventory)) {
            return;
        }
        for (Direction side : Iterate.directions) {
            IItemHandler handler;
            if (side != Direction.DOWN || (handler = this.getAdjacentInventory(side)) == null || !this.tryPullingFrom(handler)) continue;
            return;
        }
    }

    public boolean tryPullingFrom(IItemHandler handler) {
        ItemStack extract = ItemHelper.extract(handler, stack -> {
            if (!PackageItem.isPackage(stack)) {
                return false;
            }
            String filterString = this.getFilterString();
            return filterString == null || handler instanceof PackagerItemHandler || !PackageItem.matchAddress(stack, filterString);
        }, false);
        if (extract.m_41619_()) {
            return false;
        }
        this.startAnimation(extract, true);
        return true;
    }

    protected IItemHandler getAdjacentInventory(Direction side) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (blockEntity == null || blockEntity instanceof FrogportBlockEntity) {
            return null;
        }
        return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side.m_122424_()).orElse(null);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128350_("PlacedYaw", this.passiveYaw);
        if (this.animatedPackage != null && this.isAnimationInProgress()) {
            tag.m_128365_("AnimatedPackage", (Tag)this.animatedPackage.serializeNBT());
            tag.m_128379_("Deposit", this.currentlyDepositing);
        }
        if (this.sendAnticipate) {
            this.sendAnticipate = false;
            tag.m_128379_("Anticipate", true);
        }
        if (this.failedLastExport) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"FailedLastExport");
        }
        if (this.goggles) {
            NBTHelper.putMarker((CompoundTag)tag, (String)"Goggles");
        }
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.passiveYaw = tag.m_128457_("PlacedYaw");
        this.failedLastExport = tag.m_128471_("FailedLastExport");
        this.goggles = tag.m_128471_("Goggles");
        if (!clientPacket) {
            this.animatedPackage = null;
        }
        if (tag.m_128441_("AnimatedPackage")) {
            this.deferAnimationInward = tag.m_128471_("Deposit");
            this.deferAnimationStart = ItemStack.m_41712_((CompoundTag)tag.m_128469_("AnimatedPackage"));
        }
        if (clientPacket && tag.m_128441_("Anticipate")) {
            this.anticipate();
        }
    }

    public float getYaw() {
        if (this.target == null) {
            return this.passiveYaw;
        }
        Vec3 diff = this.target.getExactTargetLocation(this, (LevelAccessor)this.f_58857_, this.f_58858_).m_82546_(Vec3.m_82512_((Vec3i)this.f_58858_));
        return (float)(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_) * 57.2957763671875) + 180.0f;
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean superTip = IHaveHoveringInformation.super.addToTooltip(tooltip, isPlayerSneaking);
        if (!this.failedLastExport) {
            return superTip;
        }
        TooltipHelper.addHint(tooltip, "hint.blocked_frogport", new Object[0]);
        return true;
    }

    @Override
    protected void onOpenedManually() {
        if (this.f_58857_.m_5776_()) {
            this.sounds.open(this.f_58857_, this.f_58858_);
        }
    }

    @Override
    public InteractionResult use(Player player) {
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack mainHandItem = player.m_21205_();
        if (!this.goggles && AllItems.GOGGLES.isIn(mainHandItem)) {
            this.goggles = true;
            if (!this.f_58857_.m_5776_()) {
                this.notifyUpdate();
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11676_, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(player);
    }
}

