/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes.astralsorcery;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AstralSorceryAttunementAttribute
implements ItemAttribute {
    String constellationName;

    public AstralSorceryAttunementAttribute(String constellationName) {
        this.constellationName = constellationName;
    }

    private static CompoundTag extractAstralNBT(ItemStack stack) {
        return stack.m_41783_() != null ? stack.m_41783_().m_128469_("astralsorcery") : new CompoundTag();
    }

    @Override
    public boolean appliesTo(ItemStack itemStack, Level level) {
        CompoundTag nbt = AstralSorceryAttunementAttribute.extractAstralNBT(itemStack);
        String constellation = nbt.m_128441_("constellation") ? nbt.m_128461_("constellation") : nbt.m_128461_("constellationName");
        ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
        if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
            constellation = itemResource.toString().replace("shifting_star_", "");
        }
        return constellation.equals(this.constellationName);
    }

    @Override
    public String getTranslationKey() {
        return "astralsorcery_constellation";
    }

    @Override
    public Object[] getTranslationParameters() {
        ResourceLocation constResource = new ResourceLocation(this.constellationName);
        String something = Component.m_237115_((String)String.format("%s.constellation.%s", constResource.m_135827_(), constResource.m_135815_())).getString();
        return new Object[]{something};
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.ASTRAL_ATTUNMENT;
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128359_("constellation", this.constellationName);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.constellationName = nbt.m_128461_("constellation");
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new AstralSorceryAttunementAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack itemStack, Level level) {
            CompoundTag nbt = AstralSorceryAttunementAttribute.extractAstralNBT(itemStack);
            String constellation = nbt.m_128441_("constellation") ? nbt.m_128461_("constellation") : nbt.m_128461_("constellationName");
            ResourceLocation itemResource = ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_());
            if (itemResource != null && itemResource.toString().contains("shifting_star_")) {
                constellation = itemResource.toString().replace("shifting_star_", "");
            }
            ArrayList<ItemAttribute> atts = new ArrayList<ItemAttribute>();
            if (constellation.length() > 0) {
                atts.add(new AstralSorceryAttunementAttribute(constellation));
            }
            return atts;
        }
    }
}

