/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.AllFluids;
import com.simibubi.create.api.effect.OpenPipeEffectHandler;
import com.simibubi.create.content.fluids.FlowSource;
import com.simibubi.create.content.fluids.FluidReactions;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.mixin.accessor.FlowingFluidAccessor;
import com.simibubi.create.infrastructure.config.AllConfigs;
import javax.annotation.Nullable;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class OpenEndedPipe
extends FlowSource {
    private Level world;
    private BlockPos pos;
    private AABB aoe;
    private OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private BlockPos outputPos;
    private boolean wasPulling;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new AABB(this.outputPos).m_82363_(0.0, -1.0, 0.0);
        if (face.getFace() == Direction.DOWN) {
            this.aoe = this.aoe.m_82363_(0.0, -1.0, 0.0);
        }
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getOutputPos() {
        return this.outputPos;
    }

    public AABB getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(Level world) {
        this.world = world;
    }

    @Override
    public LazyOptional<IFluidHandler> provideHandler() {
        return LazyOptional.of(() -> this.fluidHandler);
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        this.fluidHandler.writeToNBT(compound);
        compound.m_128379_("Pulling", this.wasPulling);
        compound.m_128365_("Location", (Tag)this.location.serializeNBT());
        return compound;
    }

    public static OpenEndedPipe fromNBT(CompoundTag compound, BlockPos blockEntityPos) {
        BlockFace fromNBT = BlockFace.fromNBT((CompoundTag)compound.m_128469_("Location"));
        OpenEndedPipe oep = new OpenEndedPipe(new BlockFace(blockEntityPos, fromNBT.getFace()));
        oep.fluidHandler.readFromNBT(compound);
        oep.wasPulling = compound.m_128471_("Pulling");
        return oep;
    }

    private FluidStack removeFluidFromSpace(boolean simulate) {
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            return empty;
        }
        if (!this.world.m_46749_(this.outputPos)) {
            return empty;
        }
        BlockState state = this.world.m_8055_(this.outputPos);
        FluidState fluidState = state.m_60819_();
        boolean waterlog = state.m_61138_((Property)BlockStateProperties.f_61362_);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, simulate);
        if (!drainBlock.isEmpty()) {
            if (!simulate && state.m_61138_((Property)BlockStateProperties.f_61421_) && AllFluids.HONEY.is((Object)drainBlock.getFluid())) {
                AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.HONEY_DRAIN);
            }
            return drainBlock;
        }
        if (!waterlog && !state.m_247087_()) {
            return empty;
        }
        if (fluidState.m_76178_() || !fluidState.m_76170_()) {
            return empty;
        }
        FluidStack stack = new FluidStack(fluidState.m_76152_(), 1000);
        if (simulate) {
            return stack;
        }
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((BlockGetter)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        if (waterlog) {
            this.world.m_7731_(this.outputPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            this.world.m_186469_(this.outputPos, (Fluid)Fluids.f_76193_, 1);
        } else {
            FlowingFluidAccessor flowing;
            FluidState potentiallyFilled;
            BlockState newState = (BlockState)fluidState.m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(14));
            FluidState newFluidState = newState.m_60819_();
            Fluid fluid = newFluidState.m_76152_();
            if (fluid instanceof FlowingFluidAccessor && (potentiallyFilled = (flowing = (FlowingFluidAccessor)fluid).create$getNewLiquid(this.world, this.outputPos, newState)).equals(fluidState)) {
                return stack;
            }
            this.world.m_7731_(this.outputPos, newState, 3);
        }
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, boolean simulate) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.m_46749_(this.outputPos)) {
            return false;
        }
        BlockState state = this.world.m_8055_(this.outputPos);
        FluidState fluidState = state.m_60819_();
        boolean waterlog = state.m_61138_((Property)BlockStateProperties.f_61362_);
        if (!waterlog && !state.m_247087_()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!(fluid.getFluid() instanceof FlowingFluid)) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid())) {
            return true;
        }
        if (!fluidState.m_76178_() && FluidHelper.convertToStill(fluidState.m_76152_()) != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.m_76170_()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != Fluids.f_76193_) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (!((Boolean)AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        if (this.world.m_6042_().f_63857_() && FluidHelper.isTag(fluid, (TagKey<Fluid>)FluidTags.f_13131_)) {
            int i = this.outputPos.m_123341_();
            int j = this.outputPos.m_123342_();
            int k = this.outputPos.m_123343_();
            this.world.m_6263_(null, (double)i, (double)j, (double)k, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (this.world.f_46441_.m_188501_() - this.world.f_46441_.m_188501_()) * 0.8f);
            return true;
        }
        if (waterlog) {
            this.world.m_7731_(this.outputPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)), 3);
            this.world.m_186469_(this.outputPos, (Fluid)Fluids.f_76193_, 1);
            return true;
        }
        this.world.m_7731_(this.outputPos, fluid.getFluid().m_76145_().m_76188_(), 3);
        return true;
    }

    private class OpenEndFluidHandler
    extends FluidTank {
        public OpenEndFluidHandler() {
            super(1000);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            OpenPipeEffectHandler effectHandler;
            if (OpenEndedPipe.this.world == null) {
                return 0;
            }
            if (!OpenEndedPipe.this.world.m_46749_(OpenEndedPipe.this.outputPos)) {
                return 0;
            }
            if (resource.isEmpty()) {
                return 0;
            }
            if (!OpenEndedPipe.this.provideFluidToSpace(resource, true)) {
                return 0;
            }
            FluidStack containedFluidStack = this.getFluid();
            boolean hasBlockState = FluidHelper.hasBlockState(containedFluidStack.getFluid());
            if (!containedFluidStack.isEmpty() && !containedFluidStack.isFluidEqual(resource)) {
                this.setFluid(FluidStack.EMPTY);
            }
            if (OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = false;
            }
            if ((effectHandler = OpenPipeEffectHandler.REGISTRY.get(resource.getFluid())) != null && !hasBlockState) {
                resource = FluidHelper.copyStackWithAmount(resource, 1);
            }
            int fill = super.fill(resource, action);
            if (action.simulate()) {
                return fill;
            }
            if (effectHandler != null && !resource.isEmpty()) {
                FluidStack exposed = hasBlockState ? resource.copy() : resource;
                effectHandler.apply(OpenEndedPipe.this.world, OpenEndedPipe.this.aoe, exposed);
            }
            if ((this.getFluidAmount() == 1000 || !hasBlockState) && OpenEndedPipe.this.provideFluidToSpace(containedFluidStack, false)) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fill;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.drainInner(resource.getAmount(), resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return this.drainInner(maxDrain, null, action);
        }

        private FluidStack drainInner(int amount, @Nullable FluidStack filter, IFluidHandler.FluidAction action) {
            FluidStack drainedFromInternal;
            boolean filterPresent;
            FluidStack empty = FluidStack.EMPTY;
            boolean bl = filterPresent = filter != null;
            if (OpenEndedPipe.this.world == null) {
                return empty;
            }
            if (!OpenEndedPipe.this.world.m_46749_(OpenEndedPipe.this.outputPos)) {
                return empty;
            }
            if (amount == 0) {
                return empty;
            }
            if (amount > 1000) {
                amount = 1000;
                if (filterPresent) {
                    filter = FluidHelper.copyStackWithAmount(filter, amount);
                }
            }
            if (!OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = true;
            }
            FluidStack fluidStack = drainedFromInternal = filterPresent ? super.drain(filter, action) : super.drain(amount, action);
            if (!drainedFromInternal.isEmpty()) {
                return drainedFromInternal;
            }
            FluidStack drainedFromWorld = OpenEndedPipe.this.removeFluidFromSpace(action.simulate());
            if (drainedFromWorld.isEmpty()) {
                return FluidStack.EMPTY;
            }
            if (filterPresent && !drainedFromWorld.isFluidEqual(filter)) {
                return FluidStack.EMPTY;
            }
            int remainder = drainedFromWorld.getAmount() - amount;
            drainedFromWorld.setAmount(amount);
            if (!action.simulate() && remainder > 0) {
                if (!this.getFluid().isEmpty() && !this.getFluid().isFluidEqual(drainedFromWorld)) {
                    this.setFluid(FluidStack.EMPTY);
                }
                super.fill(FluidHelper.copyStackWithAmount(drainedFromWorld, remainder), IFluidHandler.FluidAction.EXECUTE);
            }
            return drainedFromWorld;
        }
    }
}

