/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.zapper.ConfigureZapperPacket;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Vector;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ZapperScreen
extends AbstractSimiScreen {
    protected final Component patternSection = CreateLang.translateDirect("gui.terrainzapper.patternSection", new Object[0]);
    protected AllGuiTextures background;
    protected ItemStack zapper;
    protected InteractionHand hand;
    protected float animationProgress;
    protected Component title;
    protected Vector<IconButton> patternButtons = new Vector(6);
    private IconButton confirmButton;
    protected int brightColor;
    protected int fontColor;
    protected PlacementPatterns currentPattern;

    public ZapperScreen(AllGuiTextures background, ItemStack zapper, InteractionHand hand) {
        this.background = background;
        this.zapper = zapper;
        this.hand = hand;
        this.title = CommonComponents.f_237098_;
        this.brightColor = 0xFEFEFE;
        this.fontColor = 5726074;
        CompoundTag nbt = zapper.m_41784_();
        this.currentPattern = (PlacementPatterns)NBTHelper.readEnum((CompoundTag)nbt, (String)"Pattern", PlacementPatterns.class);
    }

    protected void m_7856_() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-10, 0);
        super.m_7856_();
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.m_7379_());
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.patternButtons.clear();
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + this.background.getWidth() - 76 + col * 18, y + 21 + row * 18, pattern.icon);
                patternButton.withCallback(() -> {
                    this.patternButtons.forEach(b -> {
                        b.green = false;
                    });
                    patternButton.green = true;
                    this.currentPattern = pattern;
                });
                patternButton.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.pattern." + pattern.translationKey, new Object[0]));
                this.patternButtons.add(patternButton);
            }
        }
        this.patternButtons.get((int)this.currentPattern.ordinal()).green = true;
        this.addRenderableWidgets(this.patternButtons);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.drawOnBackground(graphics, x, y);
        this.renderBlock(graphics, x, y);
        this.renderZapper(graphics, x, y);
    }

    protected void drawOnBackground(GuiGraphics graphics, int x, int y) {
        graphics.m_280614_(this.f_96547_, this.title, x + (this.background.getWidth() - this.f_96547_.m_92852_((FormattedText)this.title)) / 2, y + 4, 5513551, false);
    }

    public void m_86600_() {
        super.m_86600_();
        this.animationProgress += 5.0f;
    }

    public void m_7861_() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        AllPackets.getChannel().sendToServer((Object)packet);
    }

    protected void renderZapper(GuiGraphics graphics, int x, int y) {
        GuiGameElement.of((ItemStack)this.zapper).scale(4.0).at((float)(x + this.background.getWidth()), (float)(y + this.background.getHeight() - 48), -200.0f).render(graphics);
    }

    protected void renderBlock(GuiGraphics graphics, int x, int y) {
        PoseStack ms = graphics.m_280168_();
        ms.m_85836_();
        ms.m_252880_((float)(x + 32), (float)(y + 42), 120.0f);
        ms.m_252781_(Axis.f_252529_.m_252977_(-25.0f));
        ms.m_252781_(Axis.f_252436_.m_252977_(-45.0f));
        ms.m_85841_(20.0f, 20.0f, 20.0f);
        BlockState state = Blocks.f_50016_.m_49966_();
        if (this.zapper.m_41782_() && this.zapper.m_41783_().m_128441_("BlockUsed")) {
            state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)this.zapper.m_41783_().m_128469_("BlockUsed"));
        }
        GuiGameElement.of((BlockState)state).render(graphics);
        ms.m_85849_();
    }

    protected abstract ConfigureZapperPacket getConfigurationPacket();
}

