/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.steamWhistle;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WhistleExtenderBlock
extends Block
implements IWrenchable {
    public static final EnumProperty<WhistleExtenderShape> SHAPE = EnumProperty.m_61587_((String)"shape", WhistleExtenderShape.class);
    public static final EnumProperty<WhistleBlock.WhistleSize> SIZE = WhistleBlock.SIZE;

    public WhistleExtenderBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(SHAPE, (Comparable)((Object)WhistleExtenderShape.SINGLE))).m_61124_(SIZE, (Comparable)((Object)WhistleBlock.WhistleSize.MEDIUM)));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (context.m_43720_().f_82480_ < (double)((float)context.m_8083_().m_123342_() + 0.5f) || state.m_61143_(SHAPE) == WhistleExtenderShape.SINGLE) {
            return IWrenchable.super.onSneakWrenched(state, context);
        }
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)WhistleExtenderShape.SINGLE)), 3);
        IWrenchable.playRemoveSound(world, pos);
        return InteractionResult.SUCCESS;
    }

    protected UseOnContext relocateContext(UseOnContext context, BlockPos target) {
        return new UseOnContext(context.m_43723_(), context.m_43724_(), new BlockHitResult(context.m_43720_(), context.m_43719_(), target, context.m_43721_()));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null || !AllBlocks.STEAM_WHISTLE.isIn(pPlayer.m_21120_(pHand))) {
            return InteractionResult.PASS;
        }
        Level level = pLevel;
        BlockPos findRoot = WhistleExtenderBlock.findRoot((LevelAccessor)level, pPos);
        BlockState blockState = level.m_8055_(findRoot);
        Block block = blockState.m_60734_();
        if (block instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)block;
            return whistle.m_6227_(blockState, pLevel, findRoot, pPlayer, pHand, new BlockHitResult(pHit.m_82450_(), pHit.m_82434_(), findRoot, pHit.m_82436_()));
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos findRoot;
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(findRoot = WhistleExtenderBlock.findRoot((LevelAccessor)level, context.m_8083_()));
        Block block = blockState.m_60734_();
        if (block instanceof WhistleBlock) {
            WhistleBlock whistle = (WhistleBlock)block;
            return whistle.onWrenched(blockState, this.relocateContext(context, findRoot));
        }
        return IWrenchable.super.onWrenched(state, context);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return AllBlocks.STEAM_WHISTLE.asStack();
    }

    public static BlockPos findRoot(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockState;
        BlockPos currentPos = pPos.m_7495_();
        while (AllBlocks.STEAM_WHISTLE_EXTENSION.has(blockState = pLevel.m_8055_(currentPos))) {
            currentPos = currentPos.m_7495_();
        }
        return currentPos;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        return below.m_60713_((Block)this) && below.m_61143_(SHAPE) != WhistleExtenderShape.SINGLE || AllBlocks.STEAM_WHISTLE.has(below);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing.m_122434_() != Direction.Axis.Y) {
            return pState;
        }
        if (pFacing == Direction.UP) {
            boolean connected = pState.m_61143_(SHAPE) == WhistleExtenderShape.DOUBLE_CONNECTED;
            boolean shouldConnect = pLevel.m_8055_(pCurrentPos.m_7494_()).m_60713_((Block)this);
            if (!connected && shouldConnect) {
                return (BlockState)pState.m_61124_(SHAPE, (Comparable)((Object)WhistleExtenderShape.DOUBLE_CONNECTED));
            }
            if (connected && !shouldConnect) {
                return (BlockState)pState.m_61124_(SHAPE, (Comparable)((Object)WhistleExtenderShape.DOUBLE));
            }
            return pState;
        }
        return !pState.m_60710_((LevelReader)pLevel, pCurrentPos) ? Blocks.f_50016_.m_49966_() : (BlockState)pState.m_61124_(SIZE, (Comparable)((Object)((WhistleBlock.WhistleSize)((Object)pLevel.m_8055_(pCurrentPos.m_7495_()).m_61143_(SIZE)))));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (pOldState.m_60734_() != this || pOldState.m_61143_(SHAPE) != pState.m_61143_(SHAPE)) {
            WhistleBlock.queuePitchUpdate((LevelAccessor)pLevel, WhistleExtenderBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pNewState.m_60734_() != this) {
            WhistleBlock.queuePitchUpdate((LevelAccessor)pLevel, WhistleExtenderBlock.findRoot((LevelAccessor)pLevel, pPos));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{SHAPE, SIZE}));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)pState.m_61143_(SIZE));
        switch ((WhistleExtenderShape)((Object)pState.m_61143_(SHAPE))) {
            case DOUBLE: {
                return size == WhistleBlock.WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE : (size == WhistleBlock.WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE : AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE);
            }
            case DOUBLE_CONNECTED: {
                return size == WhistleBlock.WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE_DOUBLE_CONNECTED : (size == WhistleBlock.WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM_DOUBLE_CONNECTED : AllShapes.WHISTLE_EXTENDER_SMALL_DOUBLE_CONNECTED);
            }
        }
        return size == WhistleBlock.WhistleSize.LARGE ? AllShapes.WHISTLE_EXTENDER_LARGE : (size == WhistleBlock.WhistleSize.MEDIUM ? AllShapes.WHISTLE_EXTENDER_MEDIUM : AllShapes.WHISTLE_EXTENDER_SMALL);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return AllBlocks.STEAM_WHISTLE.has(neighborState) && dir == Direction.DOWN;
    }

    public static enum WhistleExtenderShape implements StringRepresentable
    {
        SINGLE,
        DOUBLE,
        DOUBLE_CONNECTED;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

